/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;

public class RestfulResultSet
extends AbstractResultSet
implements ResultSet {
    private volatile boolean isClosed;
    private int pos = -1;
    private final String database;
    private final Statement statement;
    private final ArrayList<ArrayList<Object>> resultSet;
    private ArrayList<String> columnNames;
    private ArrayList<Field> columns;
    private RestfulResultSetMetaData metaData;

    public RestfulResultSet(String database, Statement statement, JSONObject resultJson) throws SQLException {
        this.database = database;
        this.statement = statement;
        JSONArray columnMeta = resultJson.getJSONArray("column_meta");
        this.columnNames = new ArrayList();
        this.columns = new ArrayList();
        for (int colIndex = 0; colIndex < columnMeta.size(); ++colIndex) {
            JSONArray col = columnMeta.getJSONArray(colIndex);
            String col_name = col.getString(0);
            int taos_type = col.getInteger(1);
            int col_type = TSDBConstants.taosType2JdbcType(taos_type);
            int col_length = col.getInteger(2);
            this.columnNames.add(col_name);
            this.columns.add(new Field(col_name, col_type, col_length, "", taos_type));
        }
        this.metaData = new RestfulResultSetMetaData(this.database, this.columns, this);
        JSONArray data = resultJson.getJSONArray("data");
        this.resultSet = new ArrayList();
        for (int rowIndex = 0; rowIndex < data.size(); ++rowIndex) {
            ArrayList<Object> row = new ArrayList<Object>();
            JSONArray jsonRow = data.getJSONArray(rowIndex);
            for (int colIndex = 0; colIndex < jsonRow.size(); ++colIndex) {
                row.add(this.parseColumnData(jsonRow, colIndex, this.columns.get((int)colIndex).taos_type));
            }
            this.resultSet.add(row);
        }
    }

    private Object parseColumnData(JSONArray row, int colIndex, int taosType) throws SQLException {
        switch (taosType) {
            case 1: {
                return row.getBoolean(colIndex);
            }
            case 2: {
                return row.getByte(colIndex);
            }
            case 3: {
                return row.getShort(colIndex);
            }
            case 4: {
                return row.getInteger(colIndex);
            }
            case 5: {
                return row.getLong(colIndex);
            }
            case 6: {
                return row.getFloat(colIndex);
            }
            case 7: {
                return row.getDouble(colIndex);
            }
            case 9: {
                if (row.get(colIndex) == null) {
                    return null;
                }
                String timestampFormat = this.statement.getConnection().getClientInfo("timestampFormat");
                if ("TIMESTAMP".equalsIgnoreCase(timestampFormat)) {
                    Long value = row.getLong(colIndex);
                    if (value < 10000000000000L) {
                        return new Timestamp(value);
                    }
                    long epochSec = value / 1000000L;
                    long nanoAdjustment = value % 1000000L * 1000L;
                    return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
                }
                if ("UTC".equalsIgnoreCase(timestampFormat)) {
                    String value = row.getString(colIndex);
                    long epochSec = Timestamp.valueOf(value.substring(0, 19).replace("T", " ")).getTime() / 1000L;
                    int fractionalSec = Integer.parseInt(value.substring(20, value.length() - 5));
                    long nanoAdjustment = 0L;
                    nanoAdjustment = value.length() > 28 ? (long)fractionalSec * 1000L : (long)fractionalSec * 1000000L;
                    ZoneOffset zoneOffset = ZoneOffset.of(value.substring(value.length() - 5));
                    Instant instant = Instant.ofEpochSecond(epochSec, nanoAdjustment).atOffset(zoneOffset).toInstant();
                    return Timestamp.from(instant);
                }
                String value = row.getString(colIndex);
                if (value.length() <= 23) {
                    return row.getTimestamp(colIndex);
                }
                long epochSec = Timestamp.valueOf(value.substring(0, 19)).getTime() / 1000L;
                long nanoAdjustment = (long)Integer.parseInt(value.substring(20)) * 1000L;
                Timestamp timestamp = Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
                return timestamp;
            }
            case 8: {
                return row.getString(colIndex) == null ? null : row.getString(colIndex).getBytes();
            }
            case 10: {
                return row.getString(colIndex) == null ? null : row.getString(colIndex);
            }
        }
        return row.get(colIndex);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        ++this.pos;
        return this.pos <= this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulResultSet> clazz = RestfulResultSet.class;
        synchronized (RestfulResultSet.class) {
            this.isClosed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            this.wasNull = true;
            return false;
        }
        this.wasNull = false;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == -128L) {
            return 0;
        }
        if (valueAsLong < -128L || valueAsLong > 127L) {
            this.throwRangeException(value.toString(), columnIndex, -6);
        }
        return (byte)valueAsLong;
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == -32768L) {
            return 0;
        }
        if (valueAsLong < -32768L || valueAsLong > 32767L) {
            this.throwRangeException(value.toString(), columnIndex, 5);
        }
        return (short)valueAsLong;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == Integer.MIN_VALUE) {
            return 0;
        }
        if (valueAsLong < Integer.MIN_VALUE || valueAsLong > Integer.MAX_VALUE) {
            this.throwRangeException(value.toString(), columnIndex, 4);
        }
        return (int)valueAsLong;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            this.wasNull = true;
            return 0L;
        }
        this.wasNull = false;
        if (value instanceof Timestamp) {
            return ((Timestamp)value).getTime();
        }
        long valueAsLong = 0L;
        try {
            valueAsLong = Long.parseLong(value.toString());
            if (valueAsLong == Long.MIN_VALUE) {
                return 0L;
            }
        }
        catch (NumberFormatException e) {
            this.throwRangeException(value.toString(), columnIndex, -5);
        }
        return valueAsLong;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            this.wasNull = true;
            return 0.0f;
        }
        this.wasNull = false;
        if (value instanceof Float || value instanceof Double) {
            return ((Float)value).floatValue();
        }
        return Float.parseFloat(value.toString());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            this.wasNull = true;
            return 0.0;
        }
        this.wasNull = false;
        if (value instanceof Double || value instanceof Float) {
            return (Double)value;
        }
        return Double.parseDouble(value.toString());
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof Long) {
            return Longs.toByteArray((long)((Long)value));
        }
        if (value instanceof Integer) {
            return Ints.toByteArray((int)((Integer)value));
        }
        if (value instanceof Short) {
            return Shorts.toByteArray((short)((Short)value));
        }
        if (value instanceof Byte) {
            return new byte[]{(Byte)value};
        }
        return value.toString().getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        return Date.valueOf(value.toString());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return new Time(((Timestamp)value).getTime());
        }
        return Time.valueOf(value.toString());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        return Timestamp.valueOf(value.toString());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        return this.resultSet.get(this.pos).get(columnIndex - 1);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        int columnIndex = this.columnNames.indexOf(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("cannot find Column in resultSet");
        }
        return columnIndex + 1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        if (value == null) {
            return null;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return new BigDecimal(Long.valueOf(value.toString()));
        }
        if (value instanceof Double || value instanceof Float) {
            return new BigDecimal(Double.valueOf(value.toString()));
        }
        if (value instanceof Timestamp) {
            return new BigDecimal(((Timestamp)value).getTime());
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos == -1 && this.resultSet.size() != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos >= this.resultSet.size() && this.resultSet.size() != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        return this.pos == this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = this.resultSet.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = this.resultSet.size() - 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int row;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.pos < 0 || this.pos >= this.resultSet.size()) {
                return 0;
            }
            row = this.pos + 1;
        }
        return row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public class Field {
        String name;
        int type;
        int length;
        String note;
        int taos_type;

        public Field(String name, int type, int length, String note, int taos_type) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.note = note;
            this.taos_type = taos_type;
        }
    }
}

