/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Utils {
    private static Pattern ptn = Pattern.compile(".*?'");

    public static String escapeSingleQuota(String origin) {
        Matcher m = ptn.matcher(origin);
        StringBuffer sb = new StringBuffer();
        int end = 0;
        while (m.find()) {
            end = m.end();
            String seg = origin.substring(m.start(), end);
            int len = seg.length();
            if (len == 1) {
                if ('\'' == seg.charAt(0)) {
                    sb.append("\\'");
                    continue;
                }
                sb.append(seg);
                continue;
            }
            sb.append(seg.substring(0, seg.length() - 2));
            char lastcSec = seg.charAt(seg.length() - 2);
            if (lastcSec == '\\') {
                sb.append("\\'");
                continue;
            }
            sb.append(lastcSec);
            sb.append("\\'");
        }
        if (end < origin.length()) {
            sb.append(origin.substring(end));
        }
        return sb.toString();
    }

    public static String getNativeSql(String rawSql, Object[] parameters) {
        String preparedSql = rawSql.trim().toLowerCase();
        String[] clause = new String[]{};
        if (SqlSyntaxValidator.isInsertSql(preparedSql)) {
            clause = new String[]{"values\\s*\\(.*?\\)", "tags\\s*\\(.*?\\)"};
        }
        if (SqlSyntaxValidator.isSelectSql(preparedSql)) {
            clause = new String[]{"where\\s*.*"};
        }
        HashMap<Integer, Integer> placeholderPositions = new HashMap<Integer, Integer>();
        TreeRangeSet clauseRangeSet = TreeRangeSet.create();
        Utils.findPlaceholderPosition(preparedSql, placeholderPositions);
        Utils.findClauseRangeSet(preparedSql, clause, (RangeSet<Integer>)clauseRangeSet);
        return Utils.transformSql(preparedSql, parameters, placeholderPositions, (RangeSet<Integer>)clauseRangeSet);
    }

    private static void findClauseRangeSet(String preparedSql, String[] regexArr, RangeSet<Integer> clauseRangeSet) {
        clauseRangeSet.clear();
        for (String regex : regexArr) {
            Matcher matcher = Pattern.compile(regex).matcher(preparedSql);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                clauseRangeSet.add(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
        }
    }

    private static void findPlaceholderPosition(String preparedSql, Map<Integer, Integer> placeholderPosition) {
        placeholderPosition.clear();
        Matcher matcher = Pattern.compile("\\?").matcher(preparedSql);
        int index = 0;
        while (matcher.find()) {
            int pos = matcher.start();
            placeholderPosition.put(index, pos);
            ++index;
        }
    }

    private static String transformSql(String preparedSql, Object[] paramArr, Map<Integer, Integer> placeholderPosition, RangeSet<Integer> clauseRangeSet) {
        String[] sqlArr = preparedSql.split("\\?");
        return IntStream.range(0, sqlArr.length).mapToObj(index -> {
            String paraStr;
            if (index == paramArr.length) {
                return sqlArr[index];
            }
            Object para = paramArr[index];
            if (para != null) {
                paraStr = para instanceof byte[] ? new String((byte[])para, Charset.forName("UTF-8")) : para.toString();
                if (para instanceof Timestamp || para instanceof String || para instanceof byte[]) {
                    paraStr = Utils.escapeSingleQuota(paraStr);
                    Integer pos = (Integer)placeholderPosition.get(index);
                    boolean contains = clauseRangeSet.contains((Comparable)pos);
                    if (contains) {
                        paraStr = "'" + paraStr + "'";
                    }
                }
            } else {
                paraStr = "NULL";
            }
            return sqlArr[index] + paraStr;
        }).collect(Collectors.joining());
    }
}

