/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.WrapperImpl;
import com.taosdata.jdbc.rs.RestfulResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RestfulResultSetMetaData
extends WrapperImpl
implements ResultSetMetaData {
    private final String database;
    private List<RestfulResultSet.Field> fields;
    private final RestfulResultSet resultSet;

    public RestfulResultSetMetaData(String database, ArrayList<RestfulResultSet.Field> fields, RestfulResultSet resultSet) {
        this.database = database;
        this.fields = fields == null ? Collections.emptyList() : fields;
        this.resultSet = resultSet;
    }

    public List<RestfulResultSet.Field> getFields() {
        return this.fields;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int type = this.fields.get((int)(column - 1)).type;
        switch (type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.fields.get((int)(column - 1)).length;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.fields.get((int)(column - 1)).name;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.fields.get((int)(column - 1)).name;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int type = this.fields.get((int)(column - 1)).type;
        switch (type) {
            case 6: {
                return 5;
            }
            case 8: {
                return 9;
            }
            case -15: 
            case -2: {
                return this.fields.get((int)(column - 1)).length;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        int type = this.fields.get((int)(column - 1)).type;
        switch (type) {
            case 6: {
                return 5;
            }
            case 8: {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.database;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.fields.get((int)(column - 1)).type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int taos_type = this.fields.get((int)(column - 1)).taos_type;
        return TSDBConstants.taosType2JdbcTypeName(taos_type);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int type = this.fields.get((int)(column - 1)).type;
        String columnClassName = "";
        switch (type) {
            case 16: {
                return Boolean.class.getName();
            }
            case -6: 
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 6: {
                return Float.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case -15: 
            case -2: {
                return String.class.getName();
            }
        }
        return columnClassName;
    }
}

