/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.TimestampFormat;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RestfulStatement
extends AbstractStatement {
    private boolean closed;
    private String database;
    private final RestfulConnection conn;
    private volatile RestfulResultSet resultSet;
    private volatile int affectedRows;

    public RestfulStatement(RestfulConnection conn, String database) {
        this.conn = conn;
        this.database = database;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            throw TSDBError.createSQLException(8969, "not a valid sql for executeQuery: " + sql);
        }
        return this.executeOneQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!SqlSyntaxValidator.isValidForExecuteUpdate(sql)) {
            throw TSDBError.createSQLException(8971, "not a valid sql for executeUpdate: " + sql);
        }
        return this.executeOneUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulStatement> clazz = RestfulStatement.class;
        synchronized (RestfulStatement.class) {
            if (!this.isClosed()) {
                this.closed = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        boolean result = true;
        if (SqlSyntaxValidator.isUseSql(sql)) {
            HttpClientPoolUtil.execute(this.getUrl(), sql, this.conn.getToken());
            this.database = sql.trim().replace("use", "").trim();
            this.conn.setCatalog(this.database);
            result = false;
        } else if (SqlSyntaxValidator.isDatabaseUnspecifiedQuery(sql)) {
            this.executeOneQuery(sql);
        } else if (SqlSyntaxValidator.isDatabaseUnspecifiedUpdate(sql)) {
            this.executeOneUpdate(sql);
            result = false;
        } else if (SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            this.executeOneQuery(sql);
        } else {
            this.executeOneUpdate(sql);
            result = false;
        }
        return result;
    }

    private String getUrl() throws SQLException {
        String url;
        TimestampFormat timestampFormat = TimestampFormat.valueOf(this.conn.getClientInfo("timestampFormat").trim().toUpperCase());
        switch (timestampFormat) {
            case TIMESTAMP: {
                url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sqlt";
                break;
            }
            case UTC: {
                url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sqlutc";
                break;
            }
            default: {
                url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sql";
            }
        }
        return url;
    }

    private ResultSet executeOneQuery(String sql) throws SQLException {
        String result = HttpClientPoolUtil.execute(this.getUrl(), sql, this.conn.getToken());
        JSONObject resultJson = JSON.parseObject((String)result);
        if (resultJson.getString("status").equals("error")) {
            throw TSDBError.createSQLException(resultJson.getInteger("code"), resultJson.getString("desc"));
        }
        this.resultSet = new RestfulResultSet(this.database, this, resultJson);
        this.affectedRows = 0;
        return this.resultSet;
    }

    private int executeOneUpdate(String sql) throws SQLException {
        String result = HttpClientPoolUtil.execute(this.getUrl(), sql, this.conn.getToken());
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (jsonObject.getString("status").equals("error")) {
            throw TSDBError.createSQLException(jsonObject.getInteger("code"), jsonObject.getString("desc"));
        }
        this.resultSet = null;
        this.affectedRows = this.getAffectedRows(jsonObject);
        return this.affectedRows;
    }

    private int getAffectedRows(JSONObject jsonObject) throws SQLException {
        JSONArray head = jsonObject.getJSONArray("head");
        if (head.size() != 1 || !"affected_rows".equals(head.getString(0))) {
            throw TSDBError.createSQLException(8963);
        }
        JSONArray data = jsonObject.getJSONArray("data");
        if (data != null) {
            return data.getJSONArray(0).getInteger(0);
        }
        throw TSDBError.createSQLException(8963);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.conn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

