/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.utils.NullType;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;

public class TSDBResultSetRowData {
    private ArrayList<Object> data;
    private final int colSize;

    public TSDBResultSetRowData(int colSize) {
        this.colSize = colSize;
        this.clear();
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
        if (this.colSize == 0) {
            return;
        }
        this.data = new ArrayList(this.colSize);
        this.data.addAll(Collections.nCopies(this.colSize, null));
    }

    public boolean wasNull(int col) {
        return this.data.get(col - 1) == null;
    }

    public void setBooleanValue(int col, boolean value) {
        this.setBoolean(col - 1, value);
    }

    public void setBoolean(int col, boolean value) {
        this.data.set(col, value);
    }

    public boolean getBoolean(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        switch (nativeType) {
            case 1: {
                return (Boolean)obj;
            }
            case 2: {
                return (Byte)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return (Short)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return (Integer)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return (Long)obj == 1L ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: 
            case 10: {
                return obj.toString().contains("1");
            }
        }
        return false;
    }

    public void setByteValue(int colIndex, byte value) {
        this.setByte(colIndex - 1, value);
    }

    public void setByte(int col, byte value) {
        this.data.set(col, value);
    }

    public void setShortValue(int colIndex, short value) {
        this.setShort(colIndex - 1, value);
    }

    public void setShort(int col, short value) {
        this.data.set(col, value);
    }

    public void setIntValue(int colIndex, int value) {
        this.setInt(colIndex - 1, value);
    }

    public void setInt(int col, int value) {
        this.data.set(col, value);
    }

    public int getInt(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return NullType.getIntNull();
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1 : 0;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return (Integer)obj;
            }
            case 5: 
            case 9: {
                return ((Long)obj).intValue();
            }
            case 8: 
            case 10: {
                return Integer.parseInt((String)obj);
            }
            case 11: {
                return this.parseUnsignedTinyIntToInt(obj);
            }
            case 12: {
                return this.parseUnsignedSmallIntToInt(obj);
            }
            case 13: {
                return this.parseUnsignedIntegerToInt(obj);
            }
            case 14: {
                return this.parseUnsignedBigIntToInt(obj);
            }
            case 6: {
                return ((Float)obj).intValue();
            }
            case 7: {
                return ((Double)obj).intValue();
            }
        }
        return 0;
    }

    private byte parseUnsignedTinyIntToInt(Object obj) throws SQLException {
        byte value = (Byte)obj;
        if (value < 0) {
            throw TSDBError.createSQLException(8980);
        }
        return value;
    }

    private short parseUnsignedSmallIntToInt(Object obj) throws SQLException {
        short value = (Short)obj;
        if (value < 0) {
            throw TSDBError.createSQLException(8980);
        }
        return value;
    }

    private int parseUnsignedIntegerToInt(Object obj) throws SQLException {
        int value = (Integer)obj;
        if (value < 0) {
            throw TSDBError.createSQLException(8980);
        }
        return value;
    }

    private int parseUnsignedBigIntToInt(Object obj) throws SQLException {
        long value = (Long)obj;
        if (value < 0L) {
            throw TSDBError.createSQLException(8980);
        }
        return (int)value;
    }

    public void setLongValue(int colIndex, long value) {
        this.setLong(colIndex - 1, value);
    }

    public void setLong(int col, long value) {
        this.data.set(col, value);
    }

    public long getLong(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return NullType.getBigIntNull();
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1L : 0L;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return (Long)obj;
            }
            case 8: 
            case 10: {
                return Long.parseLong((String)obj);
            }
            case 11: {
                byte value = (Byte)obj;
                if (value < 0) {
                    throw TSDBError.createSQLException(8980);
                }
                return value;
            }
            case 12: {
                short value = (Short)obj;
                if (value < 0) {
                    throw TSDBError.createSQLException(8980);
                }
                return value;
            }
            case 13: {
                int value = (Integer)obj;
                if (value < 0) {
                    throw TSDBError.createSQLException(8980);
                }
                return value;
            }
            case 14: {
                long value = (Long)obj;
                if (value < 0L) {
                    throw TSDBError.createSQLException(8980);
                }
                return value;
            }
            case 6: {
                return ((Float)obj).longValue();
            }
            case 7: {
                return ((Double)obj).longValue();
            }
        }
        return 0L;
    }

    public void setFloatValue(int colIndex, float value) {
        this.setFloat(colIndex - 1, value);
    }

    public void setFloat(int col, float value) {
        this.data.set(col, Float.valueOf(value));
    }

    public float getFloat(int col, int nativeType) {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return NullType.getFloatNull();
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1.0f : 0.0f;
            }
            case 6: {
                return ((Float)obj).floatValue();
            }
            case 7: {
                return ((Double)obj).floatValue();
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return ((Long)obj).longValue();
            }
        }
        return NullType.getFloatNull();
    }

    public void setDoubleValue(int colIndex, double value) {
        this.setDouble(colIndex - 1, value);
    }

    public void setDouble(int col, double value) {
        this.data.set(col, value);
    }

    public double getDouble(int col, int nativeType) {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return NullType.getDoubleNull();
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1.0 : 0.0;
            }
            case 6: {
                return ((Float)obj).floatValue();
            }
            case 7: {
                return (Double)obj;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return ((Long)obj).longValue();
            }
        }
        return NullType.getDoubleNull();
    }

    public void setStringValue(int colIndex, String value) {
        this.data.set(colIndex - 1, value);
    }

    public void setString(int col, String value) {
        this.data.set(col, value == null ? null : value.getBytes());
    }

    public void setByteArrayValue(int colIndex, byte[] value) {
        this.setByteArray(colIndex - 1, value);
    }

    public void setByteArray(int col, byte[] value) {
        try {
            this.data.set(col, new String(value, TaosGlobalConfig.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getString(int col, int nativeType) {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return null;
        }
        switch (nativeType) {
            case 11: {
                byte value = new Byte(String.valueOf(obj));
                if (value >= 0) {
                    return Byte.toString(value);
                }
                return Integer.toString(value & 0xFF);
            }
            case 12: {
                short value = new Short(String.valueOf(obj));
                if (value >= 0) {
                    return Short.toString(value);
                }
                return Integer.toString(value & 0xFFFF);
            }
            case 13: {
                int value = new Integer(String.valueOf(obj));
                if (value >= 0) {
                    return Integer.toString(value);
                }
                return Long.toString((long)value & 0xFFFFFFFFL);
            }
            case 14: {
                long value = new Long(String.valueOf(obj));
                if (value >= 0L) {
                    return Long.toString(value);
                }
                long lowValue = value & Long.MAX_VALUE;
                return BigDecimal.valueOf(lowValue).add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.valueOf(1L)).toString();
            }
            case 8: {
                return new String((byte[])obj);
            }
            case 10: {
                return (String)obj;
            }
        }
        return String.valueOf(obj);
    }

    public void setTimestampValue(int colIndex, long value) {
        this.setTimestamp(colIndex - 1, value, 0);
    }

    public void setTimestamp(int col, long ts, int precision) {
        int fracNanoseconds;
        long milliseconds;
        switch (precision) {
            case 0: {
                milliseconds = ts;
                fracNanoseconds = (int)(ts * 1000000L % 1000000000L);
                break;
            }
            case 1: {
                milliseconds = ts / 1000L;
                fracNanoseconds = (int)(ts * 1000L % 1000000000L);
                break;
            }
            case 2: {
                milliseconds = ts / 1000000L;
                fracNanoseconds = (int)(ts % 1000000000L);
                break;
            }
            default: {
                throw new IllegalArgumentException("precision is not valid. precision: " + precision);
            }
        }
        Timestamp tsObj = new Timestamp(milliseconds);
        tsObj.setNanos(fracNanoseconds);
        this.data.set(col, tsObj);
    }

    public void setTimestamp(int col, long ts) {
        if (ts < 10000000000000L) {
            this.data.set(col, new Timestamp(ts));
        } else {
            long epochSec = ts / 1000000L;
            long nanoAdjustment = ts % 1000000L * 1000L;
            Timestamp timestamp = Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
            this.data.set(col, timestamp);
        }
    }

    public Timestamp getTimestamp(int col, int nativeType) {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return null;
        }
        if (nativeType == 5) {
            return new Timestamp((Long)obj);
        }
        return (Timestamp)obj;
    }

    public Object getObject(int col) {
        return this.data.get(col - 1);
    }
}

