/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.TimestampFormat;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSClient;
import com.taosdata.jdbc.ws.WSConnection;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class RestfulDriver
extends AbstractDriver {
    private static final String URL_PREFIX = "jdbc:TAOS-RS://";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String password;
        String user;
        if (url == null || url.trim().isEmpty() || url.trim().replaceAll("\\s", "").isEmpty()) {
            throw TSDBError.createSQLException(8978);
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = this.parseURL(url, info);
        String host = props.getProperty("host");
        String port = props.getProperty("port", "6041");
        String database = props.containsKey("dbname") ? props.getProperty("dbname") : null;
        try {
            if (!props.containsKey("user")) {
                throw TSDBError.createSQLException(8985);
            }
            if (!props.containsKey("password")) {
                throw TSDBError.createSQLException(8986);
            }
            user = URLEncoder.encode(props.getProperty("user"), StandardCharsets.UTF_8.displayName());
            password = URLEncoder.encode(props.getProperty("password"), StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw TSDBError.createSQLException(8963, "unsupported UTF-8 concoding, user: " + props.getProperty("user") + ", password: " + props.getProperty("password"));
        }
        String batchLoad = info.getProperty("batchfetch");
        if (Boolean.parseBoolean(batchLoad)) {
            Transport transport;
            String loginUrl = "ws://" + props.getProperty("host") + ":" + props.getProperty("port") + "/rest/ws";
            try {
                int timeout = props.containsKey("messageWaitTimeout") ? Integer.parseInt(props.getProperty("messageWaitTimeout")) : 3000;
                int maxRequest = props.containsKey("maxConcurrentRequest") ? Integer.parseInt(props.getProperty("maxConcurrentRequest")) : 100;
                InFlightRequest inFlightRequest = new InFlightRequest(timeout, maxRequest);
                CountDownLatch latch = new CountDownLatch(1);
                HashMap<String, String> httpHeaders = new HashMap<String, String>();
                WSClient client = new WSClient(new URI(loginUrl), user, password, database, inFlightRequest, httpHeaders, latch, maxRequest);
                transport = new Transport(client, inFlightRequest);
                if (!client.connectBlocking(timeout, TimeUnit.MILLISECONDS)) {
                    throw new SQLException("can't create connection with server");
                }
                if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                    throw new SQLException("auth timeout");
                }
                if (!client.isAuth()) {
                    throw new SQLException("auth failure");
                }
            }
            catch (URISyntaxException e) {
                throw new SQLException("Websocket url parse error: " + loginUrl, e);
            }
            catch (InterruptedException e) {
                throw new SQLException("creat websocket connection has been Interrupted ", e);
            }
            props.setProperty("timestampFormat", String.valueOf((Object)TimestampFormat.TIMESTAMP));
            return new WSConnection(url, props, transport, database);
        }
        String loginUrl = "http://" + props.getProperty("host") + ":" + props.getProperty("port") + "/rest/login/" + user + "/" + password + "";
        int poolSize = Integer.parseInt(props.getProperty("httpPoolSize", "20"));
        boolean keepAlive = Boolean.parseBoolean(props.getProperty("httpKeepAlive", "true"));
        HttpClientPoolUtil.init(poolSize, keepAlive);
        String result = HttpClientPoolUtil.execute(loginUrl);
        JSONObject jsonResult = JSON.parseObject((String)result);
        String status = jsonResult.getString("status");
        String token = jsonResult.getString("desc");
        if (!status.equals("succ")) {
            throw new SQLException(jsonResult.getString("desc"));
        }
        RestfulConnection conn = new RestfulConnection(host, port, props, database, url, token);
        if (database != null && !database.trim().replaceAll("\\s", "").isEmpty()) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("use " + database);
            }
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.trim().length() > 0 && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new RestfulDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8978, e);
        }
    }
}

