/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientPoolUtil {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final int DEFAULT_MAX_RETRY_COUNT = 5;
    public static final String DEFAULT_HTTP_KEEP_ALIVE = "true";
    public static final String DEFAULT_MAX_PER_ROUTE = "20";
    private static final int DEFAULT_HTTP_KEEP_TIME = -1;
    public static final String DEFAULT_CONNECT_TIMEOUT = "5000";
    public static final String DEFAULT_SOCKET_TIMEOUT = "5000";
    private static String isKeepAlive;
    private static final ConnectionKeepAliveStrategy DEFAULT_KEEP_ALIVE_STRATEGY;
    private static volatile CloseableHttpClient httpClient;
    private static int connectTimeout;
    private static int socketTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Properties props) {
        int poolSize = Integer.parseInt(props.getProperty("httpPoolSize", DEFAULT_MAX_PER_ROUTE));
        boolean keepAlive = Boolean.parseBoolean(props.getProperty("httpKeepAlive", DEFAULT_HTTP_KEEP_ALIVE));
        connectTimeout = Integer.parseInt(props.getProperty("httpConnectTimeout", "5000"));
        socketTimeout = Integer.parseInt(props.getProperty("httpSocketTimeout", "5000"));
        if (httpClient != null) return;
        Class<HttpClientPoolUtil> clazz = HttpClientPoolUtil.class;
        synchronized (HttpClientPoolUtil.class) {
            if (httpClient != null) return;
            isKeepAlive = keepAlive ? "Keep-Alive" : "Close";
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(poolSize * 10);
            connectionManager.setDefaultMaxPerRoute(poolSize);
            httpClient = HttpClients.custom().setKeepAliveStrategy(DEFAULT_KEEP_ALIVE_STRATEGY).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((exception, executionCount, httpContext) -> executionCount < 5).build();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(String uri) throws SQLException {
        HttpEntity httpEntity = null;
        String responseBody = "";
        HttpRequestBase method = HttpClientPoolUtil.getRequest(uri, "GET");
        HttpClientContext context = HttpClientContext.create();
        try {
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)context);){
                httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
                }
            }
            if (httpEntity == null) return responseBody;
        }
        catch (ClientProtocolException e) {
            try {
                throw TSDBError.createSQLException(8983, e.getMessage());
                catch (IOException exception) {
                    throw TSDBError.createSQLException(8984, exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (httpEntity == null) throw throwable;
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return responseBody;
    }

    public static String execute(String uri, String data, String auth) throws SQLException {
        return HttpClientPoolUtil.execute(uri, data, auth, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(String uri, String data, String auth, Long reqId) throws SQLException {
        String responseBody;
        if (reqId != null) {
            uri = uri.contains("?") ? uri + "&reqId=" + reqId : uri + "?reqId=" + reqId;
        }
        HttpEntityEnclosingRequestBase method = (HttpEntityEnclosingRequestBase)HttpClientPoolUtil.getRequest(uri, "POST");
        method.setHeader("Content-Type", "text/plain");
        method.setHeader("Connection", isKeepAlive);
        if (auth != null) {
            method.setHeader("Authorization", auth);
        }
        method.setEntity((HttpEntity)new StringEntity(data, StandardCharsets.UTF_8));
        HttpClientContext context = HttpClientContext.create();
        HttpEntity httpEntity = null;
        try {
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)context);){
                httpEntity = httpResponse.getEntity();
                if (httpEntity == null) {
                    throw TSDBError.createSQLException(8988, "httpEntity is null, sql: " + data);
                }
                responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            }
            if (httpEntity == null) return responseBody;
        }
        catch (ClientProtocolException e) {
            try {
                throw TSDBError.createSQLException(8983, e.getMessage());
                catch (IOException exception) {
                    throw TSDBError.createSQLException(8984, exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (httpEntity == null) throw throwable;
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return responseBody;
    }

    private static HttpRequestBase getRequest(String uri, String methodName) {
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(false).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(1000).setSocketTimeout(socketTimeout).build();
        Object method = "PUT".equalsIgnoreCase(methodName) ? new HttpPut(uri) : ("POST".equalsIgnoreCase(methodName) ? new HttpPost(uri) : ("GET".equalsIgnoreCase(methodName) ? new HttpGet(uri) : new HttpPost(uri)));
        method.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        method.addHeader("Accept", DEFAULT_CONTENT_TYPE);
        method.setConfig(requestConfig);
        return method;
    }

    static {
        DEFAULT_KEEP_ALIVE_STRATEGY = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement headerElement = it.nextElement();
                String param = headerElement.getName();
                String value = headerElement.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return -1000L;
        };
        connectTimeout = 0;
        socketTimeout = 0;
    }
}

