/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.utils.UnsignedDataUtils;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.ws.AbstractWSResultSet;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.FetchBlockResp;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.RequestFactory;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BlockResultSet
extends AbstractWSResultSet {
    public BlockResultSet(Statement statement, Transport transport, QueryResp response, String database) throws SQLException {
        super(statement, transport, response, database);
    }

    @Override
    public List<List<Object>> fetchJsonData() throws SQLException {
        Request blockRequest = RequestFactory.generateFetchBlock(this.queryId);
        FetchBlockResp resp = (FetchBlockResp)this.transport.send(blockRequest);
        ByteBuffer buffer = resp.getBuffer();
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        if (resp.getBuffer() != null) {
            int bitMapOffset = this.BitmapLen(this.numOfRows);
            int pHeader = buffer.position() + 28 + this.fields.size() * 5;
            buffer.position(pHeader);
            ArrayList<Integer> lengths = new ArrayList<Integer>(this.fields.size());
            for (int i = 0; i < this.fields.size(); ++i) {
                lengths.add(buffer.getInt());
            }
            pHeader = buffer.position();
            int length = 0;
            for (int i = 0; i < this.fields.size(); ++i) {
                ArrayList<Object> col = new ArrayList<Object>(this.numOfRows);
                int type = ((RestfulResultSet.Field)this.fields.get(i)).getTaosType();
                switch (type) {
                    case 1: 
                    case 2: 
                    case 11: {
                        int j;
                        length = bitMapOffset;
                        byte[] tmp = new byte[bitMapOffset];
                        buffer.get(tmp);
                        for (j = 0; j < this.numOfRows; ++j) {
                            byte b = buffer.get();
                            if (this.isNull(tmp, j)) {
                                col.add(null);
                                continue;
                            }
                            col.add(b);
                        }
                        break;
                    }
                    case 3: 
                    case 12: {
                        int j;
                        length = bitMapOffset;
                        byte[] tmp = new byte[bitMapOffset];
                        buffer.get(tmp);
                        for (j = 0; j < this.numOfRows; ++j) {
                            short s = buffer.getShort();
                            if (this.isNull(tmp, j)) {
                                col.add(null);
                                continue;
                            }
                            col.add(s);
                        }
                        break;
                    }
                    case 4: 
                    case 13: {
                        int j;
                        length = bitMapOffset;
                        byte[] tmp = new byte[bitMapOffset];
                        buffer.get(tmp);
                        for (j = 0; j < this.numOfRows; ++j) {
                            int in = buffer.getInt();
                            if (this.isNull(tmp, j)) {
                                col.add(null);
                                continue;
                            }
                            col.add(in);
                        }
                        break;
                    }
                    case 5: 
                    case 9: 
                    case 14: {
                        int j;
                        length = bitMapOffset;
                        byte[] tmp = new byte[bitMapOffset];
                        buffer.get(tmp);
                        for (j = 0; j < this.numOfRows; ++j) {
                            long l = buffer.getLong();
                            if (this.isNull(tmp, j)) {
                                col.add(null);
                                continue;
                            }
                            col.add(l);
                        }
                        break;
                    }
                    case 6: {
                        int j;
                        length = bitMapOffset;
                        byte[] tmp = new byte[bitMapOffset];
                        buffer.get(tmp);
                        for (j = 0; j < this.numOfRows; ++j) {
                            float f = buffer.getFloat();
                            if (this.isNull(tmp, j)) {
                                col.add(null);
                                continue;
                            }
                            col.add(Float.valueOf(f));
                        }
                        break;
                    }
                    case 7: {
                        int j;
                        length = bitMapOffset;
                        byte[] tmp = new byte[bitMapOffset];
                        buffer.get(tmp);
                        for (j = 0; j < this.numOfRows; ++j) {
                            double d = buffer.getDouble();
                            if (this.isNull(tmp, j)) {
                                col.add(null);
                                continue;
                            }
                            col.add(d);
                        }
                        break;
                    }
                    case 8: 
                    case 15: 
                    case 16: 
                    case 20: {
                        Object[] tmp;
                        int len;
                        int m;
                        int m2;
                        length = this.numOfRows * 4;
                        ArrayList<Integer> offset = new ArrayList<Integer>(this.numOfRows);
                        for (m2 = 0; m2 < this.numOfRows; ++m2) {
                            offset.add(buffer.getInt());
                        }
                        int start = buffer.position();
                        for (m = 0; m < this.numOfRows; ++m) {
                            if (-1 == (Integer)offset.get(m)) {
                                col.add(null);
                                continue;
                            }
                            buffer.position(start + (Integer)offset.get(m));
                            len = buffer.getShort() & 0xFFFF;
                            tmp = new byte[len];
                            buffer.get((byte[])tmp);
                            col.add(tmp);
                        }
                        break;
                    }
                    case 10: {
                        Object[] tmp;
                        int len;
                        int m;
                        int m2;
                        length = this.numOfRows * 4;
                        ArrayList<Integer> offset = new ArrayList(this.numOfRows);
                        for (m2 = 0; m2 < this.numOfRows; ++m2) {
                            offset.add(buffer.getInt());
                        }
                        int start = buffer.position();
                        for (m = 0; m < this.numOfRows; ++m) {
                            if (-1 == (Integer)offset.get(m)) {
                                col.add(null);
                                continue;
                            }
                            buffer.position(start + (Integer)offset.get(m));
                            len = (buffer.getShort() & 0xFFFF) / 4;
                            tmp = new int[len];
                            for (int n = 0; n < len; ++n) {
                                tmp[n] = buffer.getInt();
                            }
                            col.add(tmp);
                        }
                        break;
                    }
                    default: {
                        col.add(null);
                    }
                }
                buffer.position(pHeader += length + (Integer)lengths.get(i));
                list.add(col);
            }
        }
        return list;
    }

    private Timestamp parseTimestampColumnData(long value) {
        if (0 == this.timestampPrecision) {
            return new Timestamp(value);
        }
        if (1 == this.timestampPrecision) {
            long epochSec = value / 1000000L;
            long nanoAdjustment = value % 1000000L * 1000L;
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        if (2 == this.timestampPrecision) {
            long epochSec = value / 1000000000L;
            long nanoAdjustment = value % 1000000000L;
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        return null;
    }

    public Object parseValue(int columnIndex) {
        Object source = ((List)this.result.get(columnIndex - 1)).get(this.rowIndex);
        if (null == source) {
            return null;
        }
        int type = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (type) {
            case 1: {
                byte val = (Byte)source;
                return val == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 11: {
                byte val = (Byte)source;
                return UnsignedDataUtils.parseUTinyInt(val);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 20: {
                return source;
            }
            case 12: {
                short val = (Short)source;
                return UnsignedDataUtils.parseUSmallInt(val);
            }
            case 13: {
                int val = (Integer)source;
                return UnsignedDataUtils.parseUInteger(val);
            }
            case 9: {
                long val = (Long)source;
                return this.parseTimestampColumnData(val);
            }
            case 14: {
                long val = (Long)source;
                return UnsignedDataUtils.parseUBigInt(val);
            }
            case 10: {
                int[] tmp = (int[])source;
                return new String(tmp, 0, tmp.length);
            }
        }
        return null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            String charset = TaosGlobalConfig.getCharset();
            try {
                return new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return value.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return false;
        }
        this.wasNull = false;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 2: {
                return (Byte)value == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 3: 
            case 11: {
                return (Short)value == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 4: 
            case 12: {
                return (Integer)value == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 5: 
            case 13: {
                return (Long)value == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 9: {
                return ((Timestamp)value).getTime() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 14: {
                return value.equals(new BigDecimal(0)) ? Boolean.FALSE : Boolean.TRUE;
            }
            case 6: {
                return ((Float)value).floatValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE;
            }
            case 7: {
                return (Double)value == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 10: {
                if ("TRUE".compareToIgnoreCase((String)value) == 0) {
                    return Boolean.TRUE;
                }
                if ("FALSE".compareToIgnoreCase((String)value) == 0) {
                    return Boolean.FALSE;
                }
                throw new SQLDataException();
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                if ("TRUE".compareToIgnoreCase(tmp) == 0) {
                    return Boolean.TRUE;
                }
                if ("FALSE".compareToIgnoreCase(tmp) == 0) {
                    return Boolean.FALSE;
                }
                throw new SQLDataException();
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Byte) {
            return (Byte)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? (byte)1 : 0;
            }
            case 3: 
            case 11: {
                short tmp = (Short)value;
                if (tmp < -128 || tmp > 127) {
                    this.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 4: 
            case 12: {
                int tmp = (Integer)value;
                if (tmp < -128 || tmp > 127) {
                    this.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 5: 
            case 13: {
                long tmp = (Long)value;
                if (tmp < -128L || tmp > 127L) {
                    this.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)value;
                if (tmp.compareTo(new BigDecimal(-128)) < 0 || tmp.compareTo(new BigDecimal(127)) > 0) {
                    this.throwRangeException(value.toString(), columnIndex, -6);
                }
                return tmp.byteValue();
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -128.0f || tmp > 127.0f) {
                    this.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -128.0 || tmp > 127.0) {
                    this.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 10: {
                return Byte.parseByte((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Byte.parseByte(tmp);
            }
        }
        return 0;
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Short) {
            return (Short)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? (short)1 : 0;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 11: {
                return (Short)value;
            }
            case 4: 
            case 12: {
                int tmp = (Integer)value;
                if (tmp < Short.MIN_VALUE || tmp > Short.MAX_VALUE) {
                    this.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 5: 
            case 13: {
                long tmp = (Long)value;
                if (tmp < -32768L || tmp > 32767L) {
                    this.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)value;
                if (tmp.compareTo(new BigDecimal(Short.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Short.MAX_VALUE)) > 0) {
                    this.throwRangeException(value.toString(), columnIndex, 5);
                }
                return tmp.shortValue();
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -32768.0f || tmp > 32767.0f) {
                    this.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -32768.0 || tmp > 32767.0) {
                    this.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 10: {
                return Short.parseShort((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Short.parseShort(tmp);
            }
        }
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Integer) {
            return (Integer)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1 : 0;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return (Integer)value;
            }
            case 5: 
            case 13: {
                long tmp = (Long)value;
                if (tmp < Integer.MIN_VALUE || tmp > Integer.MAX_VALUE) {
                    this.throwRangeException(value.toString(), columnIndex, 4);
                }
                return (int)tmp;
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)value;
                if (tmp.compareTo(new BigDecimal(Integer.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Integer.MAX_VALUE)) > 0) {
                    this.throwRangeException(value.toString(), columnIndex, 4);
                }
                return tmp.intValue();
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -2.1474836E9f || tmp > 2.1474836E9f) {
                    this.throwRangeException(value.toString(), columnIndex, 4);
                }
                return (int)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -2.147483648E9 || tmp > 2.147483647E9) {
                    this.throwRangeException(value.toString(), columnIndex, 4);
                }
                return (int)tmp;
            }
            case 10: {
                return Integer.parseInt((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Integer.parseInt(tmp);
            }
        }
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0L;
        }
        this.wasNull = false;
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            switch (this.timestampPrecision) {
                default: {
                    return ts.getTime();
                }
                case 1: {
                    return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
                }
                case 2: 
            }
            return ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000);
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1L : 0L;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)value).intValue();
            }
            case 5: 
            case 13: {
                return (Long)value;
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)value;
                if (tmp.compareTo(new BigDecimal(Long.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    this.throwRangeException(value.toString(), columnIndex, -5);
                }
                return tmp.longValue();
            }
            case 9: {
                Timestamp ts = (Timestamp)value;
                switch (this.timestampPrecision) {
                    default: {
                        return ts.getTime();
                    }
                    case 1: {
                        return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
                    }
                    case 2: 
                }
                return ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000);
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -9.223372E18f || tmp > 9.223372E18f) {
                    this.throwRangeException(value.toString(), columnIndex, -5);
                }
                return (long)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -9.223372036854776E18 || tmp > 9.223372036854776E18) {
                    this.throwRangeException(value.toString(), columnIndex, -5);
                }
                return (long)tmp;
            }
            case 10: {
                return Long.parseLong((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Long.parseLong(tmp);
            }
        }
        return 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0.0f;
        }
        this.wasNull = false;
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1.0f : 0.0f;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)value).intValue();
            }
            case 5: 
            case 13: {
                return ((Long)value).longValue();
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)value;
                if (tmp.compareTo(new BigDecimal(1.4E-45f)) < 0 || tmp.compareTo(new BigDecimal(3.4028234663852886E38)) > 0) {
                    this.throwRangeException(value.toString(), columnIndex, 6);
                }
                return tmp.floatValue();
            }
            case 7: {
                Double tmp = (Double)value;
                if (tmp < (double)1.4E-45f || tmp > 3.4028234663852886E38) {
                    this.throwRangeException(value.toString(), columnIndex, 6);
                }
                return Float.parseFloat(String.valueOf(tmp));
            }
            case 10: {
                return Float.parseFloat(value.toString());
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Float.parseFloat(tmp);
            }
        }
        return 0.0f;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0.0;
        }
        this.wasNull = false;
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return Double.parseDouble(String.valueOf(value));
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)value).intValue();
            }
            case 5: 
            case 13: {
                return ((Long)value).longValue();
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)value;
                if (tmp.compareTo(new BigDecimal(Double.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Double.MAX_VALUE)) > 0) {
                    this.throwRangeException(value.toString(), columnIndex, 8);
                }
                return tmp.floatValue();
            }
            case 10: {
                return Double.parseDouble(value.toString());
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Double.parseDouble(tmp);
            }
        }
        return 0.0;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof Long) {
            return Longs.toByteArray((long)((Long)value));
        }
        if (value instanceof Integer) {
            return Ints.toByteArray((int)((Integer)value));
        }
        if (value instanceof Short) {
            return Shorts.toByteArray((short)((Short)value));
        }
        if (value instanceof Byte) {
            return new byte[]{(Byte)value};
        }
        return value.toString().getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        if (value instanceof byte[]) {
            String tmp;
            String charset = TaosGlobalConfig.getCharset();
            try {
                tmp = new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            return Utils.parseDate(tmp);
        }
        return Utils.parseDate(value.toString());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof Timestamp) {
            return new Time(((Timestamp)value).getTime());
        }
        String tmp = "";
        if (value instanceof byte[]) {
            String charset = TaosGlobalConfig.getCharset();
            try {
                tmp = new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            tmp = value.toString();
        }
        Time time = null;
        try {
            time = Utils.parseTime(tmp);
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp ret;
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Long) {
            return this.parseTimestampColumnData((Long)value);
        }
        String tmp = "";
        if (value instanceof byte[]) {
            String charset = TaosGlobalConfig.getCharset();
            try {
                tmp = new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            tmp = value.toString();
        }
        try {
            ret = Utils.parseTimestamp(tmp);
        }
        catch (Exception e) {
            ret = null;
            this.wasNull = true;
        }
        return ret;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        int columnIndex = this.columnNames.indexOf(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("cannot find Column in result");
        }
        return columnIndex + 1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? new BigDecimal(1) : new BigDecimal(0);
            }
            case 2: {
                return new BigDecimal(((Byte)value).byteValue());
            }
            case 3: 
            case 11: {
                return new BigDecimal(((Short)value).shortValue());
            }
            case 4: 
            case 12: {
                return new BigDecimal((Integer)value);
            }
            case 5: 
            case 13: {
                return new BigDecimal((Long)value);
            }
            case 6: {
                return BigDecimal.valueOf(((Float)value).floatValue());
            }
            case 7: {
                return BigDecimal.valueOf((Double)value);
            }
            case 9: {
                return new BigDecimal(((Timestamp)value).getTime());
            }
            case 10: {
                return new BigDecimal(value.toString());
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return new BigDecimal(tmp);
            }
        }
        return new BigDecimal(0);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex == -1 && this.numOfRows != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex >= this.numOfRows && this.numOfRows != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        return this.rowIndex == this.numOfRows - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            if (this.numOfRows > 0) {
                this.rowIndex = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            if (this.numOfRows > 0) {
                this.rowIndex = this.numOfRows;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            this.rowIndex = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            this.rowIndex = this.numOfRows - 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int row;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            if (this.rowIndex < 0 || this.rowIndex >= this.numOfRows) {
                return 0;
            }
            row = this.rowIndex + 1;
        }
        return row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    private int BitmapLen(int n) {
        return n + 7 >> 3;
    }

    private boolean isNull(byte[] c, int n) {
        int position = n >>> 3;
        int index = n & 7;
        return (c[position] & 1 << 7 - index) == 1 << 7 - index;
    }
}

