/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSConnection;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.FetchBlockResp;
import com.taosdata.jdbc.ws.entity.Payload;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Base64;
import java.util.Properties;
import java.util.logging.Logger;

public class RestfulDriver
extends AbstractDriver {
    public static final String URL_PREFIX = "jdbc:TAOS-RS://";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || url.trim().isEmpty() || url.trim().replaceAll("\\s", "").isEmpty()) {
            throw TSDBError.createSQLException(8978);
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = this.parseURL(url, info);
        ConnectionParam param = ConnectionParam.getParam(props);
        String batchLoad = info.getProperty("batchfetch");
        if (Boolean.parseBoolean(batchLoad)) {
            return this.getWSConnection(url, param, props);
        }
        HttpClientPoolUtil.init(props);
        String auth = null;
        if (param.getUser() != null && param.getPassword() != null) {
            auth = Base64.getEncoder().encodeToString((param.getUser() + ":" + param.getPassword()).getBytes(StandardCharsets.UTF_8));
        }
        RestfulConnection conn = new RestfulConnection(param.getHost(), param.getPort(), props, param.getDatabase(), url, auth, param.isUseSsl(), param.getCloudToken(), param.getTz());
        if (param.getDatabase() != null && !param.getDatabase().trim().replaceAll("\\s", "").isEmpty()) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("use " + param.getDatabase());
            }
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.trim().length() > 0 && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private Connection getWSConnection(String url, ConnectionParam param, Properties props) throws SQLException {
        InFlightRequest inFlightRequest = new InFlightRequest(param.getRequestTimeout(), param.getMaxRequest());
        Transport transport = new Transport(WSFunction.WS, param, inFlightRequest);
        transport.setTextMessageHandler(message -> {
            Action action;
            JSONObject jsonObject = JSON.parseObject((String)message);
            Response response = (Response)jsonObject.toJavaObject((action = Action.of(jsonObject.getString("action"))).getResponseClazz());
            FutureResponse remove = inFlightRequest.remove(response.getAction(), response.getReqId());
            if (null != remove) {
                remove.getFuture().complete(response);
            }
        });
        transport.setBinaryMessageHandler(byteBuffer -> {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(8);
            long id = byteBuffer.getLong();
            FutureResponse remove = inFlightRequest.remove(Action.FETCH_BLOCK.getAction(), id);
            if (null != remove) {
                FetchBlockResp fetchBlockResp = new FetchBlockResp(id, (ByteBuffer)byteBuffer);
                remove.getFuture().complete(fetchBlockResp);
            }
        });
        Transport.checkConnection(transport, param.getConnectTimeout());
        ConnectReq connectReq = new ConnectReq();
        connectReq.setReqId(1L);
        connectReq.setUser(param.getUser());
        connectReq.setPassword(param.getPassword());
        connectReq.setDb(param.getDatabase());
        ConnectResp auth = (ConnectResp)transport.send(new Request(Action.CONN.getAction(), connectReq));
        if (Code.SUCCESS.getCode() != auth.getCode()) {
            transport.close();
            throw new SQLException("0x" + Integer.toHexString(auth.getCode()) + ":auth failure:" + auth.getMessage());
        }
        TaosGlobalConfig.setCharset(props.getProperty("charset"));
        return new WSConnection(url, props, transport, param);
    }

    static {
        try {
            DriverManager.registerDriver(new RestfulDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8978, e);
        }
    }

    static class ConnectReq
    extends Payload {
        private String user;
        private String password;
        private String db;

        ConnectReq() {
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }
    }
}

