/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.Consumer;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.tmq.Assignment;
import com.taosdata.jdbc.tmq.ConsumerRecord;
import com.taosdata.jdbc.tmq.ConsumerRecords;
import com.taosdata.jdbc.tmq.Deserializer;
import com.taosdata.jdbc.tmq.OffsetCommitCallback;
import com.taosdata.jdbc.tmq.TopicPartition;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.FetchBlockResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.tmq.ConsumerAction;
import com.taosdata.jdbc.ws.tmq.WSConsumerResultSet;
import com.taosdata.jdbc.ws.tmq.entity.AssignmentResp;
import com.taosdata.jdbc.ws.tmq.entity.CommitResp;
import com.taosdata.jdbc.ws.tmq.entity.ConsumerParam;
import com.taosdata.jdbc.ws.tmq.entity.PollResp;
import com.taosdata.jdbc.ws.tmq.entity.SeekResp;
import com.taosdata.jdbc.ws.tmq.entity.SubscribeResp;
import com.taosdata.jdbc.ws.tmq.entity.TMQRequestFactory;
import com.taosdata.jdbc.ws.tmq.entity.UnsubscribeResp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WSConsumer<V>
implements Consumer<V> {
    private Transport transport;
    private ConsumerParam param;
    private TMQRequestFactory factory;
    private long offset = 0L;

    @Override
    public void create(Properties properties) throws SQLException {
        this.factory = new TMQRequestFactory();
        this.param = new ConsumerParam(properties);
        InFlightRequest inFlightRequest = new InFlightRequest(this.param.getConnectionParam().getRequestTimeout(), this.param.getConnectionParam().getMaxRequest());
        this.transport = new Transport(WSFunction.TMQ, this.param.getConnectionParam(), inFlightRequest);
        this.transport.setTextMessageHandler(message -> {
            ConsumerAction action;
            JSONObject jsonObject = JSON.parseObject((String)message);
            Response response = (Response)jsonObject.toJavaObject((action = ConsumerAction.of(jsonObject.getString("action"))).getResponseClazz());
            FutureResponse remove = inFlightRequest.remove(response.getAction(), response.getReqId());
            if (null != remove) {
                remove.getFuture().complete(response);
            }
        });
        this.transport.setBinaryMessageHandler(byteBuffer -> {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(8);
            long id = byteBuffer.getLong();
            byteBuffer.position(24);
            FutureResponse remove = inFlightRequest.remove(ConsumerAction.FETCH_BLOCK.getAction(), id);
            if (null != remove) {
                FetchBlockResp fetchBlockResp = new FetchBlockResp(id, (ByteBuffer)byteBuffer);
                remove.getFuture().complete(fetchBlockResp);
            }
        });
        Transport.checkConnection(this.transport, this.param.getConnectionParam().getConnectTimeout());
    }

    @Override
    public void subscribe(Collection<String> topics) throws SQLException {
        Request request = this.factory.generateSubscribe(this.param.getConnectionParam().getUser(), this.param.getConnectionParam().getPassword(), this.param.getConnectionParam().getDatabase(), this.param.getGroupId(), this.param.getClientId(), this.param.getOffsetRest(), topics.toArray(new String[0]), String.valueOf(this.param.isAutoCommit()), this.param.getAutoCommitInterval(), this.param.getSnapshotEnable(), this.param.getMsgWithTableName());
        SubscribeResp response = (SubscribeResp)this.transport.send(request);
        if (Code.SUCCESS.getCode() != response.getCode()) {
            throw new SQLException("subscribe topic error, code: 0x(" + Integer.toHexString(response.getCode()) + "), message: " + response.getMessage());
        }
    }

    @Override
    public void unsubscribe() throws SQLException {
        Request request = this.factory.generateUnsubscribe();
        UnsubscribeResp response = (UnsubscribeResp)this.transport.send(request);
        if (Code.SUCCESS.getCode() != response.getCode()) {
            throw new SQLException("unsubscribe topic error, code: 0x(" + Integer.toHexString(response.getCode()) + "), message: " + response.getMessage() + ", timing: " + response.getTiming());
        }
    }

    @Override
    public Set<String> subscription() throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public ConsumerRecords<V> poll(Duration timeout, Deserializer<V> deserializer) throws SQLException {
        Request request = this.factory.generatePoll(timeout.toMillis());
        PollResp pollResp = (PollResp)this.transport.send(request);
        if (Code.SUCCESS.getCode() != pollResp.getCode()) {
            throw new SQLException("consumer poll error, code: 0x(" + Integer.toHexString(pollResp.getCode()) + "), message: " + pollResp.getMessage());
        }
        if (!pollResp.isHaveMessage()) {
            return ConsumerRecords.emptyRecord();
        }
        this.offset = pollResp.getMessageId();
        ConsumerRecords<V> records = new ConsumerRecords<V>(pollResp.getMessageId());
        try (WSConsumerResultSet rs = new WSConsumerResultSet(this.transport, this.factory, pollResp.getMessageId(), pollResp.getDatabase());){
            while (rs.next()) {
                String topic = pollResp.getTopic();
                String dbName = pollResp.getDatabase();
                int vGroupId = pollResp.getVgroupId();
                TopicPartition tp = new TopicPartition(topic, dbName, vGroupId);
                V v = deserializer.deserialize(rs, topic, dbName);
                ConsumerRecord<V> r = new ConsumerRecord<V>(topic, dbName, vGroupId, pollResp.getOffset(), v);
                records.put(tp, r);
            }
        }
        if (this.param.isAutoCommit()) {
            this.commitSync();
        }
        return records;
    }

    @Override
    public synchronized void commitSync() throws SQLException {
        if (0L != this.offset) {
            CommitResp commitResp = (CommitResp)this.transport.send(this.factory.generateCommit(this.offset));
            if (Code.SUCCESS.getCode() != commitResp.getCode()) {
                throw new SQLException("consumer commit error. code: 0x(" + Integer.toHexString(commitResp.getCode()) + "), message: " + commitResp.getMessage());
            }
            this.offset = 0L;
        }
    }

    @Override
    public void close() throws SQLException {
        this.transport.close();
    }

    @Override
    public void commitAsync(OffsetCommitCallback<V> callback) {
    }

    @Override
    public void seek(TopicPartition partition, long offset) throws SQLException {
        Request request = this.factory.generateSeek(partition.getTopic(), partition.getVGroupId(), offset);
        SeekResp resp = (SeekResp)this.transport.send(request);
        if (Code.SUCCESS.getCode() != resp.getCode()) {
            throw new SQLException("consumer seek error, code: 0x(" + Integer.toHexString(resp.getCode()) + "), message: " + resp.getMessage() + ", timing: " + resp.getTiming());
        }
    }

    @Override
    public long position(TopicPartition partition) throws SQLException {
        return Arrays.stream(this.getAssignment(partition.getTopic())).filter(a -> a.getVgId() == partition.getVGroupId()).findFirst().orElseThrow(() -> TSDBError.createIllegalStateException(9082)).getCurrentOffset();
    }

    @Override
    public Map<TopicPartition, Long> position(String topic) throws SQLException {
        return Arrays.stream(this.getAssignment(topic)).collect(HashMap::new, (m, a) -> m.put(new TopicPartition(topic, a.getVgId()), a.getCurrentOffset()), HashMap::putAll);
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(String topic) throws SQLException {
        return Arrays.stream(this.getAssignment(topic)).collect(HashMap::new, (m, a) -> m.put(new TopicPartition(topic, a.getVgId()), a.getBegin()), HashMap::putAll);
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(String topic) throws SQLException {
        return Arrays.stream(this.getAssignment(topic)).collect(HashMap::new, (m, a) -> m.put(new TopicPartition(topic, a.getVgId()), a.getEnd()), HashMap::putAll);
    }

    private Assignment[] getAssignment(String topic) throws SQLException {
        Request request = this.factory.generateAssignment(topic);
        AssignmentResp resp = (AssignmentResp)this.transport.send(request);
        if (Code.SUCCESS.getCode() != resp.getCode()) {
            throw new SQLException("consumer assignment error, code: 0x(" + Integer.toHexString(resp.getCode()) + "), message: " + resp.getMessage() + ", timing: " + resp.getTiming());
        }
        return resp.getAssignment();
    }
}

