/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.common;

import com.taosdata.jdbc.common.ColumnInfo;
import com.taosdata.jdbc.common.DataLengthCfg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SerializeBlock {
    private SerializeBlock() {
    }

    private static int bitMapLen(int n) {
        return n + 7 >> 3;
    }

    private static int bitPos(int n) {
        return n & 7;
    }

    private static int charOffset(int n) {
        return n >> 3;
    }

    private static byte bmSetNull(byte c, int n) {
        return (byte)(c + (1 << 7 - SerializeBlock.bitPos(n)));
    }

    private static void handleBoolean(byte[] buf, int rowIndex, int offset, Object o) {
        boolean v = (Boolean)o;
        buf[offset + rowIndex] = v ? (byte)1 : 0;
    }

    private static void SerializeInt(byte[] buf, int offset, int v) {
        buf[offset] = (byte)(v & 0xFF);
        buf[offset + 1] = (byte)(v >> 8 & 0xFF);
        buf[offset + 2] = (byte)(v >> 16 & 0xFF);
        buf[offset + 3] = (byte)(v >> 24 & 0xFF);
    }

    private static void SerializeLong(byte[] buf, int offset, long v) {
        buf[offset] = (byte)(v & 0xFFL);
        buf[offset + 1] = (byte)(v >> 8 & 0xFFL);
        buf[offset + 2] = (byte)(v >> 16 & 0xFFL);
        buf[offset + 3] = (byte)(v >> 24 & 0xFFL);
        buf[offset + 4] = (byte)(v >> 32 & 0xFFL);
        buf[offset + 5] = (byte)(v >> 40 & 0xFFL);
        buf[offset + 6] = (byte)(v >> 48 & 0xFFL);
        buf[offset + 7] = (byte)(v >> 56 & 0xFFL);
    }

    private static void SerializeShort(byte[] buf, int offset, short v) {
        buf[offset] = (byte)(v & 0xFF);
        buf[offset + 1] = (byte)(v >> 8 & 0xFF);
    }

    private static void handleNormalDataType(int dataType, byte[] buf, int rowIndex, int startOffset, Object o, int precision) throws SQLException {
        switch (dataType) {
            case 1: {
                SerializeBlock.handleBoolean(buf, rowIndex, startOffset, o);
                break;
            }
            case 2: {
                buf[rowIndex + startOffset] = (Byte)o;
                break;
            }
            case 3: {
                short v = (Short)o;
                int offset = rowIndex * 2 + startOffset;
                SerializeBlock.SerializeShort(buf, offset, v);
                break;
            }
            case 4: {
                int v = (Integer)o;
                int offset = rowIndex * 4 + startOffset;
                SerializeBlock.SerializeInt(buf, offset, v);
                break;
            }
            case 5: {
                long v = (Long)o;
                int offset = rowIndex * 8 + startOffset;
                SerializeBlock.SerializeLong(buf, offset, v);
                break;
            }
            case 6: {
                float v = ((Float)o).floatValue();
                int offset = rowIndex * 4 + startOffset;
                int f = Float.floatToIntBits(v);
                SerializeBlock.SerializeInt(buf, offset, f);
                break;
            }
            case 7: {
                double v = (Double)o;
                int offset = rowIndex * 8 + startOffset;
                long l = Double.doubleToLongBits(v);
                SerializeBlock.SerializeLong(buf, offset, l);
                break;
            }
            case 9: {
                Timestamp t = (Timestamp)o;
                long v = precision == 0 ? t.getTime() : (precision == 1 ? t.getTime() * 1000L + (long)(t.getNanos() / 1000 % 1000) : t.getTime() * 1000000L + (long)t.getNanos() % 1000000L);
                int offset = rowIndex * 8 + startOffset;
                SerializeBlock.SerializeLong(buf, offset, v);
                break;
            }
            default: {
                throw new SQLException("unsupported data type : " + dataType);
            }
        }
    }

    public static byte[] getRawBlock(List<ColumnInfo> list, int precision) throws IOException, SQLException {
        int columns = list.size();
        int rows = list.get(0).getDataList().size();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(SerializeBlock.intToBytes(1));
        buffer.write(SerializeBlock.intToBytes(0));
        buffer.write(SerializeBlock.intToBytes(rows));
        buffer.write(SerializeBlock.intToBytes(columns));
        buffer.write(SerializeBlock.intToBytes(0));
        buffer.write(SerializeBlock.longToBytes(0L));
        byte[] colInfoData = new byte[5 * columns];
        byte[] lengthData = new byte[4 * columns];
        int bitMapLen = SerializeBlock.bitMapLen(rows);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        block4: for (int colIndex = 0; colIndex < list.size(); ++colIndex) {
            Object tmp;
            ColumnInfo column = list.get(colIndex);
            Integer dataLen = DataLengthCfg.getDataLength(column.getType());
            if (column.getType() == 11 || column.getType() == 12 || column.getType() == 13 || column.getType() == 14) break;
            if (dataLen != null) {
                colInfoData[colIndex * 5] = (byte)column.getType();
                int typeLen = dataLen;
                byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                tmp = new byte[bitMapLen + rows * dataLen];
                List<Object> rowData = column.getDataList();
                for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                    if (rowData.get(rowIndex) == null) {
                        int charOffset = SerializeBlock.charOffset(rowIndex);
                        tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                        continue;
                    }
                    SerializeBlock.handleNormalDataType(column.getType(), (byte[])tmp, rowIndex, bitMapLen, rowData.get(rowIndex), precision);
                }
                data.write((byte[])tmp);
                continue;
            }
            switch (column.getType()) {
                case 8: 
                case 15: 
                case 16: 
                case 20: {
                    short len;
                    int i;
                    int offset;
                    colInfoData[colIndex * 5] = (byte)column.getType();
                    int length = 0;
                    List<Object> rowData = column.getDataList();
                    byte[] index = new byte[rows * 4];
                    tmp = new ArrayList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        offset = rowIndex * 4;
                        if (rowData.get(rowIndex) == null) {
                            for (int i2 = 0; i2 < 4; ++i2) {
                                index[offset + i2] = -1;
                            }
                            continue;
                        }
                        byte[] v = (byte[])rowData.get(rowIndex);
                        for (i = 0; i < 4; ++i) {
                            index[offset + i] = (byte)(length >> 8 * i & 0xFF);
                        }
                        len = (short)v.length;
                        tmp.add((byte)(len & 0xFF));
                        tmp.add((byte)(len >> 8 & 0xFF));
                        for (byte b : v) {
                            tmp.add(b);
                        }
                        length += v.length + 2;
                    }
                    byte[] array = SerializeBlock.intToBytes(length);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    data.write(index);
                    byte[] bytes = new byte[tmp.size()];
                    for (int i3 = 0; i3 < tmp.size(); ++i3) {
                        bytes[i3] = (Byte)tmp.get(i3);
                    }
                    data.write(bytes);
                    continue block4;
                }
                case 10: {
                    short len;
                    int i;
                    int offset;
                    colInfoData[colIndex * 5] = (byte)column.getType();
                    int length = 0;
                    byte[] index = new byte[rows * 4];
                    ByteArrayOutputStream tmp2 = new ByteArrayOutputStream();
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        int[] t;
                        offset = rowIndex * 4;
                        if (rowData.get(rowIndex) == null) {
                            for (int i4 = 0; i4 < 4; ++i4) {
                                index[offset + i4] = -1;
                            }
                            continue;
                        }
                        String v = (String)rowData.get(rowIndex);
                        for (i = 0; i < 4; ++i) {
                            index[offset + i] = (byte)(length >> 8 * i & 0xFF);
                        }
                        len = (short)(v.length() * 4);
                        tmp2.write((byte)(len & 0xFF));
                        tmp2.write((byte)(len >> 8 & 0xFF));
                        for (int i5 : t = v.codePoints().toArray()) {
                            tmp2.write(SerializeBlock.intToBytes(i5));
                        }
                        length += t.length * 4 + 2;
                    }
                    byte[] array = SerializeBlock.intToBytes(length);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    data.write(index);
                    data.write(tmp2.toByteArray());
                    continue block4;
                }
                default: {
                    throw new SQLException("unsupported data type : " + column.getType());
                }
            }
        }
        buffer.write(colInfoData);
        buffer.write(lengthData);
        buffer.write(data.toByteArray());
        byte[] block = buffer.toByteArray();
        for (int i = 0; i < 4; ++i) {
            block[4 + i] = (byte)(block.length >> 8 * i);
        }
        return block;
    }

    public static byte[] intToBytes(int v) {
        byte[] result = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 24 & 0xFF)};
        return result;
    }

    public static byte[] longToBytes(long v) {
        byte[] result = new byte[]{(byte)(v & 0xFFL), (byte)(v >> 8 & 0xFFL), (byte)(v >> 16 & 0xFFL), (byte)(v >> 24 & 0xFFL), (byte)(v >> 32 & 0xFFL), (byte)(v >> 40 & 0xFFL), (byte)(v >> 48 & 0xFFL), (byte)(v >> 56 & 0xFFL)};
        return result;
    }
}

