/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.rpc.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Url
implements Comparable<Url>,
Serializable {
    private final String protocol;
    private final String host;
    private final int port;
    private final String path;
    private final Map<String, String> parameters;
    private volatile transient String identity;

    public Url(String protocol, String host, int port) {
        this(protocol, host, port, null, null);
    }

    public Url(String protocol, String host, int port, String path) {
        this(protocol, host, port, path, null);
    }

    public Url(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, host, port, null, parameters);
    }

    public Url(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        parameters = parameters == null ? new HashMap<String, String>() : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPort(int defaultPort) {
        return this.port <= 0 ? defaultPort : this.port;
    }

    public String getAddress() {
        return this.port <= 0 ? this.host : this.host + ":" + this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        if (this.path != null && !this.path.startsWith("/")) {
            return "/" + this.path;
        }
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public int getParameter(String key, int defaultValue) {
        String value = this.getParameter(key, null);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long getParameter(String key, long defaultValue) {
        String value = this.getParameter(key, null);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public boolean getParameter(String key, boolean defaultValue) {
        String value = this.getParameter(key, null);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public String toIdentityString() {
        if (this.identity != null) {
            return this.identity;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.protocol).append("://").append(this.host).append(":").append(this.port).append(this.getAbsolutePath());
        this.identity = s.toString();
        return this.identity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Url other = (Url)obj;
        if (!Objects.equals(this.host, other.host)) {
            return false;
        }
        if (!Objects.equals(this.parameters, other.parameters)) {
            return false;
        }
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        if (!Objects.equals(this.port, other.port)) {
            return false;
        }
        return Objects.equals(this.protocol, other.protocol);
    }

    @Override
    public int compareTo(Url url) {
        int i = this.host.compareTo(url.host);
        if (i == 0) {
            i = Integer.compare(this.port, url.port);
        }
        return i;
    }
}

