/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.ha;

import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.SessionEvent;
import com.qq.tars.net.core.SessionListener;
import com.qq.tars.support.log.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionSessionListener
implements SessionListener {
    private final AtomicInteger connStat = new AtomicInteger(0);
    private final int MaxConnCount;

    public ConnectionSessionListener(int connCount) {
        this.MaxConnCount = connCount;
        LoggerFactory.getOmLogger().debug("MaxConnCount={}", (Object)this.MaxConnCount);
    }

    public synchronized void onSessionCreated(SessionEvent se) {
        if (this.connStat.get() >= this.MaxConnCount) {
            try {
                System.out.println("reached the max connection threshold, close the session.");
                se.getSession().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        LoggerFactory.getOmLogger().debug("onSessionCreated:{}", (Object)this.connStat.incrementAndGet());
    }

    public synchronized void onSessionDestroyed(SessionEvent se) {
        if ((se.getSession() == null || se.getSession().getStatus() == Session.SessionStatus.CLOSED) && this.connStat.get() > 0) {
            System.out.println("onSessionDestroyed: " + this.connStat.decrementAndGet());
        }
    }
}

