/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.node;

import com.qq.tars.client.Communicator;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.node.prx.ServerFPrx;
import com.qq.tars.support.node.prx.ServerInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.slf4j.Logger;

public class NodeHelper {
    private static final Logger omLogger = LoggerFactory.getLogger("omLogger");
    private static final NodeHelper Instance = new NodeHelper();
    private Communicator communicator;
    private ServerInfo si;

    private NodeHelper() {
    }

    public static NodeHelper getInstance() {
        return Instance;
    }

    public void setNodeInfo(Communicator comm, String app, String server) {
        this.si = new ServerInfo(app, server, this.getPid(), null);
        this.communicator = comm;
    }

    public void keepAlive() {
        try {
            if (this.communicator == null) {
                return;
            }
            String node = ConfigurationManager.getInstance().getServerConfig().getNode();
            if (StringUtils.isEmpty(node)) {
                return;
            }
            ServerFPrx nodePrx = this.communicator.stringToProxy(ServerFPrx.class, node);
            nodePrx.async_keepAlive(null, this.si);
        }
        catch (Throwable t) {
            omLogger.error("NodeHelper|keepAlive|error", t);
        }
    }

    public void reportVersion(String version) {
        try {
            if (this.communicator == null) {
                return;
            }
            String node = ConfigurationManager.getInstance().getServerConfig().getNode();
            if (StringUtils.isEmpty(node)) {
                return;
            }
            ServerFPrx nodePrx = this.communicator.stringToProxy(ServerFPrx.class, node);
            nodePrx.async_reportVersion(null, this.si.application, this.si.serverName, version);
        }
        catch (Throwable t) {
            omLogger.error("NodeHelper|reportVersion|error", t);
        }
    }

    private int getPid() {
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        String name = rmxb.getName();
        int pid = -1;
        try {
            pid = Integer.parseInt(name.split("@")[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pid;
    }
}

