/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.property;

import com.qq.tars.support.property.PropertyReportHelper;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

public final class JvmPropertyPolicy {
    private static final int MoveBits_ByteToMB = 20;

    public static final class GCTimeSum
    implements PropertyReportHelper.Policy {
        private final String gcName;
        private long lastGCTime = 0L;

        public GCTimeSum(String gcName) {
            this.gcName = gcName;
        }

        @Override
        public String desc() {
            return "Sum";
        }

        @Override
        public String get() {
            for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                if (!this.gcName.equals(gcMXBean.getName())) continue;
                long gcTime = gcMXBean.getCollectionTime();
                long t = gcTime - this.lastGCTime;
                this.lastGCTime = gcTime;
                return String.valueOf(t);
            }
            return "0";
        }

        @Override
        public void set(int v) {
        }
    }

    public static final class GCNumCount
    implements PropertyReportHelper.Policy {
        private final String gcName;
        private long lastGCNum = 0L;

        public GCNumCount(String gcName) {
            this.gcName = gcName;
        }

        @Override
        public String desc() {
            return "Count";
        }

        @Override
        public String get() {
            for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                if (!this.gcName.equals(gcMXBean.getName())) continue;
                long gcNum = gcMXBean.getCollectionCount();
                long c = gcNum - this.lastGCNum;
                this.lastGCNum = gcNum;
                return String.valueOf(c);
            }
            return "0";
        }

        @Override
        public void set(int v) {
        }
    }

    public static final class ThreadNumAvg
    implements PropertyReportHelper.Policy {
        @Override
        public String desc() {
            return "Avg";
        }

        @Override
        public String get() {
            return String.valueOf(ManagementFactory.getThreadMXBean().getThreadCount());
        }

        @Override
        public void set(int v) {
        }
    }

    public static final class MemoryHeapMaxAvg
    implements PropertyReportHelper.Policy {
        @Override
        public String desc() {
            return "Avg";
        }

        @Override
        public String get() {
            return String.valueOf(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() >> 20);
        }

        @Override
        public void set(int v) {
        }
    }

    public static final class MemoryHeapCommittedAvg
    implements PropertyReportHelper.Policy {
        @Override
        public String desc() {
            return "Avg";
        }

        @Override
        public String get() {
            return String.valueOf(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted() >> 20);
        }

        @Override
        public void set(int v) {
        }
    }

    public static final class MemoryHeapUsedAvg
    implements PropertyReportHelper.Policy {
        @Override
        public String desc() {
            return "Avg";
        }

        @Override
        public String get() {
            return String.valueOf(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed() >> 20);
        }

        @Override
        public void set(int v) {
        }
    }
}

