/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.catchexception;

import com.googlecode.catchexception.ExceptionCaptor;
import com.googlecode.catchexception.ExceptionHolder;
import com.googlecode.catchexception.ExceptionNotThrownAssertionError;
import com.googlecode.catchexception.ExceptionUtil;
import com.googlecode.catchexception.ThrowingCallable;

public class CatchException {
    public static <E extends Exception> E caughtException() {
        return ExceptionHolder.get();
    }

    public static <E extends Exception> E caughtException(Class<E> caughtExceptionType) {
        return ExceptionHolder.get();
    }

    public static void verifyException(ThrowingCallable actor) {
        CatchException.verifyException(actor, Exception.class);
    }

    public static void verifyException(ThrowingCallable actor, Class<? extends Exception> clazz) {
        CatchException.validateArguments(actor, clazz);
        CatchException.catchException(actor, clazz, true);
    }

    public static void catchException(ThrowingCallable actor) {
        CatchException.validateArguments(actor, Exception.class);
        CatchException.catchException(actor, Exception.class, false);
    }

    public static void catchException(ThrowingCallable actor, Class<? extends Exception> clazz) {
        CatchException.validateArguments(actor, clazz);
        CatchException.catchException(actor, clazz, false);
    }

    private static void catchException(ThrowingCallable actor, Class<? extends Exception> clazz, boolean assertException) {
        CatchException.resetCaughtException();
        Exception exception = ExceptionCaptor.captureThrowable(actor);
        if (exception == null) {
            if (!assertException) {
                return;
            }
            throw new ExceptionNotThrownAssertionError(clazz);
        }
        if (clazz.isAssignableFrom(exception.getClass())) {
            ExceptionHolder.set(exception);
        } else {
            if (assertException) {
                throw new ExceptionNotThrownAssertionError(clazz, exception);
            }
            ExceptionUtil.sneakyThrow(exception);
        }
    }

    private static void validateArguments(ThrowingCallable actor, Class<? extends Exception> clazz) {
        if (actor == null) {
            throw new IllegalArgumentException("obj must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("exceptionClazz must not be null");
        }
    }

    public static void resetCaughtException() {
        ExceptionHolder.set(null);
    }
}

