/*
 * Decompiled with CFR 0.152.
 */
package io.github.xxyopen.model.page;

import java.util.List;

public class PageBean<T> {
    private long pageNum;
    private long pageSize;
    private long total;
    private List<? extends T> list;

    public PageBean(long pageNum, long pageSize, long total, List<T> list) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.list = list;
    }

    public static <T> PageBean<T> of(long pageNum, long pageSize, long total, List<T> list) {
        return new PageBean<T>(pageNum, pageSize, total, list);
    }

    public long getPages() {
        if (this.pageSize == 0L) {
            return 0L;
        }
        long pages = this.getTotal() / this.pageSize;
        if (this.getTotal() % this.pageSize != 0L) {
            ++pages;
        }
        return pages;
    }

    public long getPageNum() {
        return this.pageNum;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public List<? extends T> getList() {
        return this.list;
    }

    public void setPageNum(long pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setList(List<? extends T> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageBean)) {
            return false;
        }
        PageBean other = (PageBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pageNum = this.getPageNum();
        result = result * 59 + (int)($pageNum >>> 32 ^ $pageNum);
        long $pageSize = this.getPageSize();
        result = result * 59 + (int)($pageSize >>> 32 ^ $pageSize);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "PageBean(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", list=" + this.getList() + ")";
    }
}

