/*
 * Decompiled with CFR 0.152.
 */
package io.github.xxyopen.model.resp;

import io.github.xxyopen.model.resp.IResultCode;
import io.github.xxyopen.model.resp.SysResultCode;

public class RestResult<T> {
    private int code = SysResultCode.OK.getCode();
    private String msg = SysResultCode.OK.getMsg();
    private T data;

    private RestResult() {
    }

    private RestResult(IResultCode ResponseStatus) {
        this.code = ResponseStatus.getCode();
        this.msg = ResponseStatus.getMsg();
    }

    private RestResult(T data) {
        this.data = data;
    }

    public static RestResult<Void> ok() {
        return new RestResult<Void>();
    }

    public static <T> RestResult<T> ok(T data) {
        return new RestResult<T>(data);
    }

    public static RestResult<Void> fail(IResultCode ResponseStatus) {
        return new RestResult<Void>(ResponseStatus);
    }

    public static RestResult<Void> error() {
        return new RestResult<Void>(SysResultCode.ERROR);
    }

    public boolean isOk() {
        return this.code == SysResultCode.OK.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResult)) {
            return false;
        }
        RestResult other = (RestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "RestResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

