/*
 * Decompiled with CFR 0.152.
 */
package io.github.xxyopen.web.exception;

import io.github.xxyopen.model.resp.IResultCode;
import io.github.xxyopen.model.resp.RestResult;
import io.github.xxyopen.model.resp.SysResultCode;
import io.github.xxyopen.web.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class CommonExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CommonExceptionHandler.class);

    @ExceptionHandler(value={BindException.class})
    public RestResult<Void> handlerBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        return RestResult.fail((IResultCode)SysResultCode.PARAM_ERROR);
    }

    @ExceptionHandler(value={BusinessException.class})
    public RestResult<Void> handlerBusinessException(BusinessException e) {
        log.error(e.getMessage(), (Throwable)e);
        return RestResult.fail((IResultCode)e.getResultCode());
    }

    @ExceptionHandler(value={Exception.class})
    public RestResult<Void> handlerException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return RestResult.error();
    }
}

