/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;

public class GeoRadiusStoreArgs<K>
implements CompositeArgument {
    private K storeKey;
    private K storeDistKey;
    private Long count;
    private GeoArgs.Sort sort = GeoArgs.Sort.none;

    public GeoRadiusStoreArgs withStore(K storeKey) {
        LettuceAssert.notNull(storeKey, "StoreKey must not be null");
        this.storeKey = storeKey;
        return this;
    }

    public GeoRadiusStoreArgs withStoreDist(K storeKey) {
        LettuceAssert.notNull(storeKey, "StoreKey must not be null");
        this.storeDistKey = storeKey;
        return this;
    }

    public GeoRadiusStoreArgs withCount(long count) {
        LettuceAssert.isTrue(count > 0L, "Count must be greater 0");
        this.count = count;
        return this;
    }

    public GeoRadiusStoreArgs asc() {
        return this.sort(GeoArgs.Sort.asc);
    }

    public GeoRadiusStoreArgs desc() {
        return this.sort(GeoArgs.Sort.desc);
    }

    public K getStoreKey() {
        return this.storeKey;
    }

    public K getStoreDistKey() {
        return this.storeDistKey;
    }

    public GeoRadiusStoreArgs sort(GeoArgs.Sort sort) {
        LettuceAssert.notNull((Object)sort, "Sort must not be null");
        this.sort = sort;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.sort != null && this.sort != GeoArgs.Sort.none) {
            args.add(this.sort.name());
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
        if (this.storeKey != null) {
            args.add("STORE").addKey(this.storeKey);
        }
        if (this.storeDistKey != null) {
            args.add("STOREDIST").addKey(this.storeDistKey);
        }
    }
}

