/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ChannelGroupListener;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionEventTrigger;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.PlainChannelInitializer;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisChannelInitializer;
import io.lettuce.core.RedisCommandBuilder;
import io.lettuce.core.codec.Utf8StringCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.CommandEncoder;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.ConnectionWatchdog;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.protocol.ReconnectionListener;
import io.lettuce.core.resource.ClientResources;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ConnectionBuilder {
    private static final RedisCommandBuilder<String, String> INITIALIZING_CMD_BUILDER = new RedisCommandBuilder<String, String>(new Utf8StringCodec());
    private static final Supplier<AsyncCommand<?, ?, ?>> PING_COMMAND_SUPPLIER = () -> new AsyncCommand<String, String, String>(INITIALIZING_CMD_BUILDER.ping());
    private Supplier<SocketAddress> socketAddressSupplier;
    private ConnectionEvents connectionEvents;
    private RedisChannelHandler<?, ?> connection;
    private DefaultEndpoint endpoint;
    private Supplier<CommandHandler> commandHandlerSupplier;
    private ChannelGroup channelGroup;
    private Timer timer;
    private Bootstrap bootstrap;
    private ClientOptions clientOptions;
    private Duration timeout;
    private ClientResources clientResources;
    private char[] password;
    private ReconnectionListener reconnectionListener = ReconnectionListener.NO_OP;
    private ConnectionWatchdog connectionWatchdog;
    private Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier = PlainChannelInitializer.NO_PING;

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    protected List<ChannelHandler> buildHandlers() {
        LettuceAssert.assertState(this.channelGroup != null, "ChannelGroup must be set");
        LettuceAssert.assertState(this.connectionEvents != null, "ConnectionEvents must be set");
        LettuceAssert.assertState(this.connection != null, "Connection must be set");
        LettuceAssert.assertState(this.clientResources != null, "ClientResources must be set");
        LettuceAssert.assertState(this.endpoint != null, "Endpoint must be set");
        ArrayList<ChannelHandler> handlers = new ArrayList<ChannelHandler>();
        this.connection.setOptions(this.clientOptions);
        handlers.add((ChannelHandler)new ChannelGroupListener(this.channelGroup));
        handlers.add((ChannelHandler)new CommandEncoder());
        handlers.add((ChannelHandler)this.commandHandlerSupplier.get());
        if (this.clientOptions.isAutoReconnect()) {
            handlers.add((ChannelHandler)this.createConnectionWatchdog());
        }
        handlers.add((ChannelHandler)new ConnectionEventTrigger(this.connectionEvents, this.connection, this.clientResources.eventBus()));
        if (this.clientOptions.isAutoReconnect()) {
            handlers.add((ChannelHandler)this.createConnectionWatchdog());
        }
        return handlers;
    }

    public void enablePingBeforeConnect() {
        this.pingCommandSupplier = PING_COMMAND_SUPPLIER;
    }

    public void enableAuthPingBeforeConnect() {
        this.pingCommandSupplier = () -> new AsyncCommand<String, String, String>(INITIALIZING_CMD_BUILDER.auth(new String(this.password)));
    }

    protected ConnectionWatchdog createConnectionWatchdog() {
        if (this.connectionWatchdog != null) {
            return this.connectionWatchdog;
        }
        LettuceAssert.assertState(this.bootstrap != null, "Bootstrap must be set for autoReconnect=true");
        LettuceAssert.assertState(this.timer != null, "Timer must be set for autoReconnect=true");
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set for autoReconnect=true");
        ConnectionWatchdog watchdog = new ConnectionWatchdog(this.clientResources.reconnectDelay(), this.clientOptions, this.bootstrap, this.timer, this.clientResources.eventExecutorGroup(), this.socketAddressSupplier, this.reconnectionListener, this.connection);
        this.endpoint.registerConnectionWatchdog(watchdog);
        this.connectionWatchdog = watchdog;
        return watchdog;
    }

    public RedisChannelInitializer build() {
        return new PlainChannelInitializer(this.pingCommandSupplier, this::buildHandlers, this.clientResources, this.timeout);
    }

    public ConnectionBuilder socketAddressSupplier(Supplier<SocketAddress> socketAddressSupplier) {
        this.socketAddressSupplier = socketAddressSupplier;
        return this;
    }

    public SocketAddress socketAddress() {
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set");
        return this.socketAddressSupplier.get();
    }

    public ConnectionBuilder timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public ConnectionBuilder reconnectionListener(ReconnectionListener reconnectionListener) {
        LettuceAssert.notNull(reconnectionListener, "ReconnectionListener must not be null");
        this.reconnectionListener = reconnectionListener;
        return this;
    }

    public ConnectionBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ConnectionBuilder connectionEvents(ConnectionEvents connectionEvents) {
        this.connectionEvents = connectionEvents;
        return this;
    }

    public ConnectionBuilder connection(RedisChannelHandler<?, ?> connection) {
        this.connection = connection;
        return this;
    }

    public ConnectionBuilder channelGroup(ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }

    public ConnectionBuilder commandHandler(Supplier<CommandHandler> supplier) {
        this.commandHandlerSupplier = supplier;
        return this;
    }

    public ConnectionBuilder timer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public ConnectionBuilder bootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public ConnectionBuilder endpoint(DefaultEndpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ConnectionBuilder clientResources(ClientResources clientResources) {
        this.clientResources = clientResources;
        return this;
    }

    public ConnectionBuilder password(char[] password) {
        this.password = password;
        return this;
    }

    public RedisChannelHandler<?, ?> connection() {
        return this.connection;
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public ClientOptions clientOptions() {
        return this.clientOptions;
    }

    public ClientResources clientResources() {
        return this.clientResources;
    }

    public char[] password() {
        return this.password;
    }

    public DefaultEndpoint endpoint() {
        return this.endpoint;
    }

    Supplier<AsyncCommand<?, ?, ?>> getPingCommandSupplier() {
        return this.pingCommandSupplier;
    }
}

