/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;

final class FluxOnBackpressureBuffer<O>
extends FluxOperator<O, O>
implements Fuseable {
    final Consumer<? super O> onOverflow;
    final int bufferSize;
    final boolean unbounded;
    final boolean delayError;

    FluxOnBackpressureBuffer(Flux<? extends O> source, int bufferSize, boolean unbounded, @Nullable Consumer<? super O> onOverflow) {
        super(source);
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer Size must be strictly positive");
        }
        this.bufferSize = bufferSize;
        this.unbounded = unbounded;
        this.onOverflow = onOverflow;
        this.delayError = unbounded || onOverflow != null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super O> actual) {
        this.source.subscribe(new BackpressureBufferSubscriber<O>(actual, this.bufferSize, this.unbounded, this.delayError, this.onOverflow));
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    static final class BackpressureBufferSubscriber<T>
    implements Fuseable.QueueSubscription<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Queue<T> queue;
        final Consumer<? super T> onOverflow;
        final boolean delayError;
        Subscription s;
        volatile boolean cancelled;
        volatile boolean enabledFusion;
        volatile boolean done;
        Throwable error;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BackpressureBufferSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(BackpressureBufferSubscriber.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<BackpressureBufferSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BackpressureBufferSubscriber.class, "requested");

        BackpressureBufferSubscriber(CoreSubscriber<? super T> actual, int bufferSize, boolean unbounded, boolean delayError, @Nullable Consumer<? super T> onOverflow) {
            this.actual = actual;
            this.delayError = delayError;
            this.onOverflow = onOverflow;
            Queue q = unbounded ? Queues.unbounded(bufferSize).get() : Queues.get(bufferSize).get();
            this.queue = q;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done && this.queue.isEmpty();
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.size();
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.DELAY_ERROR) {
                return this.delayError;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            if (!this.queue.offer(t)) {
                Throwable ex = Operators.onOperatorError(this.s, Exceptions.failWithOverflow(), t, this.actual.currentContext());
                if (this.onOverflow != null) {
                    try {
                        this.onOverflow.accept(t);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        ex.initCause(e);
                    }
                }
                this.onError(ex);
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            do {
                CoreSubscriber<? super T> a;
                if ((a = this.actual) == null) continue;
                if (this.enabledFusion) {
                    this.drainFused(a);
                } else {
                    this.drainRegular(a);
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainRegular(Subscriber<? super T> a) {
            int missed = 1;
            Queue<T> q = this.queue;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; r != e; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    T t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (r == e && this.checkTerminated(this.done, q.isEmpty(), a)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainFused(Subscriber<? super T> a) {
            int missed = 1;
            Queue<T> q = this.queue;
            do {
                if (this.cancelled) {
                    this.s.cancel();
                    q.clear();
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (!this.enabledFusion && WIP.getAndIncrement(this) == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        @Nullable
        public T poll() {
            return this.queue.poll();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.enabledFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
            if (this.cancelled) {
                this.s.cancel();
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

