/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxBufferPredicate<T, C extends Collection<? super T>>
extends FluxOperator<T, C> {
    final Predicate<? super T> predicate;
    final Supplier<C> bufferSupplier;
    final Mode mode;

    FluxBufferPredicate(Flux<? extends T> source, Predicate<? super T> predicate, Supplier<C> bufferSupplier, Mode mode) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
        this.mode = mode;
    }

    @Override
    public int getPrefetch() {
        return 1;
    }

    @Override
    public void subscribe(CoreSubscriber<? super C> actual) {
        Collection initialBuffer;
        try {
            initialBuffer = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null initial buffer");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        BufferPredicateSubscriber<? super T, Collection> parent = new BufferPredicateSubscriber<T, Collection>(actual, initialBuffer, this.bufferSupplier, this.predicate, this.mode);
        this.source.subscribe(parent);
    }

    static final class BufferPredicateSubscriber<T, C extends Collection<? super T>>
    extends AbstractQueue<C>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, C>,
    BooleanSupplier {
        final CoreSubscriber<? super C> actual;
        final Context ctx;
        final Supplier<C> bufferSupplier;
        final Mode mode;
        final Predicate<? super T> predicate;
        C buffer;
        boolean done;
        volatile boolean fastpath;
        volatile long requestedBuffers;
        static final AtomicLongFieldUpdater<BufferPredicateSubscriber> REQUESTED_BUFFERS = AtomicLongFieldUpdater.newUpdater(BufferPredicateSubscriber.class, "requestedBuffers");
        volatile long requestedFromSource;
        static final AtomicLongFieldUpdater<BufferPredicateSubscriber> REQUESTED_FROM_SOURCE = AtomicLongFieldUpdater.newUpdater(BufferPredicateSubscriber.class, "requestedFromSource");
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<BufferPredicateSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(BufferPredicateSubscriber.class, Subscription.class, "s");

        BufferPredicateSubscriber(CoreSubscriber<? super C> actual, C initialBuffer, Supplier<C> bufferSupplier, Predicate<? super T> predicate, Mode mode) {
            this.actual = actual;
            this.ctx = actual.currentContext();
            this.buffer = initialBuffer;
            this.bufferSupplier = bufferSupplier;
            this.predicate = predicate;
            this.mode = mode;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath = true;
                    this.requestedBuffers = Long.MAX_VALUE;
                    this.requestedFromSource = Long.MAX_VALUE;
                    this.s.request(Long.MAX_VALUE);
                } else if (!DrainUtils.postCompleteRequest(n, this.actual, this, REQUESTED_BUFFERS, this, this)) {
                    Operators.addCap(REQUESTED_FROM_SOURCE, this, n);
                    this.s.request(n);
                }
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
            Operators.onDiscardMultiple(this.buffer, this.ctx);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean isStillExpectingBuffer;
            boolean match;
            if (this.done) {
                Operators.onNextDropped(t, this.ctx);
                return true;
            }
            C b = this.buffer;
            try {
                match = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.ctx));
                Operators.onDiscardMultiple(this.buffer, this.ctx);
                Operators.onDiscard(t, this.ctx);
                return true;
            }
            if (this.mode == Mode.UNTIL && match) {
                b.add(t);
                this.onNextNewBuffer();
            } else if (this.mode == Mode.UNTIL_CUT_BEFORE && match) {
                this.onNextNewBuffer();
                b = this.buffer;
                b.add(t);
            } else if (this.mode == Mode.WHILE && !match) {
                this.onNextNewBuffer();
            } else {
                b.add(t);
            }
            if (this.fastpath) {
                return true;
            }
            boolean isNotExpectingFromSource = REQUESTED_FROM_SOURCE.decrementAndGet(this) == 0L;
            boolean bl = isStillExpectingBuffer = REQUESTED_BUFFERS.get(this) > 0L;
            return !isNotExpectingFromSource || !isStillExpectingBuffer || !REQUESTED_FROM_SOURCE.compareAndSet(this, 0L, 1L);
        }

        @Nullable
        private C triggerNewBuffer() {
            Collection c;
            C b = this.buffer;
            if (b.isEmpty()) {
                return null;
            }
            try {
                c = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, this.ctx));
                return null;
            }
            this.buffer = c;
            return b;
        }

        private void onNextNewBuffer() {
            C b = this.triggerNewBuffer();
            if (b != null) {
                if (this.fastpath) {
                    this.actual.onNext(b);
                    return;
                }
                long r = REQUESTED_BUFFERS.getAndDecrement(this);
                if (r > 0L) {
                    this.actual.onNext(b);
                    return;
                }
                this.cancel();
                this.actual.onError(Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
            }
        }

        @Override
        public CoreSubscriber<? super C> actual() {
            return this.actual;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.ctx);
                return;
            }
            this.done = true;
            Operators.onDiscardMultiple(this.buffer, this.ctx);
            this.buffer = null;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DrainUtils.postComplete(this.actual, this, REQUESTED_BUFFERS, this, this);
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.getAsBoolean();
            }
            if (key == Scannable.Attr.CAPACITY) {
                C b = this.buffer;
                return b != null ? b.size() : 0;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requestedBuffers;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public boolean getAsBoolean() {
            return this.s == Operators.cancelledSubscription();
        }

        @Override
        public Iterator<C> iterator() {
            if (this.isEmpty()) {
                return Collections.emptyIterator();
            }
            return Collections.singleton(this.buffer).iterator();
        }

        @Override
        public boolean offer(C objects) {
            throw new IllegalArgumentException();
        }

        @Override
        @Nullable
        public C poll() {
            C b = this.buffer;
            if (b != null && !b.isEmpty()) {
                this.buffer = null;
                return b;
            }
            return null;
        }

        @Override
        @Nullable
        public C peek() {
            return this.buffer;
        }

        @Override
        public int size() {
            return this.buffer == null || this.buffer.isEmpty() ? 0 : 1;
        }

        @Override
        public String toString() {
            return "FluxBufferPredicate";
        }
    }

    public static enum Mode {
        UNTIL,
        UNTIL_CUT_BEFORE,
        WHILE;

    }
}

