/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.LinkedList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Traces;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

final class FluxOnAssembly<T>
extends FluxOperator<T, T>
implements Fuseable,
AssemblyOp {
    final AssemblySnapshotException snapshotStack;
    static final boolean fullStackTrace = Boolean.parseBoolean(System.getProperty("reactor.trace.assembly.fullstacktrace", "false"));

    FluxOnAssembly(Flux<? extends T> source) {
        super(source);
        this.snapshotStack = new AssemblySnapshotException();
    }

    FluxOnAssembly(Flux<? extends T> source, @Nullable String description, boolean light) {
        super(source);
        this.snapshotStack = light ? new AssemblyLightSnapshotException(description) : new AssemblySnapshotException(description);
    }

    @Override
    public String stepName() {
        return this.snapshotStack.operatorAssemblyInformation();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL_METADATA) {
            return !this.snapshotStack.checkpointed;
        }
        return super.scanUnsafe(key);
    }

    @Override
    public String toString() {
        return this.snapshotStack.operatorAssemblyInformation();
    }

    static String getStacktrace(AssemblySnapshotException snapshotStack) {
        StackTraceElement[] stes = snapshotStack.getStackTrace();
        if (!fullStackTrace) {
            return Traces.stackTraceToSanitizedString(stes);
        }
        return Traces.stackTraceToString(stes);
    }

    static void fillStacktraceHeader(StringBuilder sb, Class<?> sourceClass, AssemblySnapshotException ase) {
        if (ase.isLight()) {
            sb.append("\nAssembly site of producer [").append(sourceClass.getName()).append("] is identified by light checkpoint [").append(ase.getMessage()).append("].");
            return;
        }
        sb.append("\nAssembly trace from producer [").append(sourceClass.getName()).append("]");
        if (ase.getMessage() != null) {
            sb.append(", described as [").append(ase.getMessage()).append("]");
        }
        sb.append(" :\n");
    }

    static <T> void subscribe(CoreSubscriber<? super T> s, Flux<? extends T> source, @Nullable AssemblySnapshotException snapshotStack) {
        if (snapshotStack != null) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
                source.subscribe(new OnAssemblyConditionalSubscriber(cs, snapshotStack, (Publisher<?>)source));
            } else {
                source.subscribe((CoreSubscriber<? super T>)new OnAssemblySubscriber<T>(s, snapshotStack, source));
            }
        }
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (this.snapshotStack != null) {
            if (actual instanceof Fuseable.ConditionalSubscriber) {
                Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
                this.source.subscribe(new OnAssemblyConditionalSubscriber(cs, this.snapshotStack, (Publisher<?>)this.source));
            } else {
                this.source.subscribe(new OnAssemblySubscriber<T>(actual, this.snapshotStack, this.source));
            }
        }
    }

    static int getParentOrThis(Scannable parent) {
        return parent.parents().filter(s -> !(s instanceof AssemblyOp)).findFirst().map(Object::hashCode).orElse(parent.hashCode());
    }

    static final class OnAssemblyConditionalSubscriber<T>
    extends OnAssemblySubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        final Fuseable.ConditionalSubscriber<? super T> actualCS;

        OnAssemblyConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, AssemblySnapshotException stacktrace, Publisher<?> parent) {
            super(actual, stacktrace, parent);
            this.actualCS = actual;
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.actualCS.tryOnNext(t);
        }
    }

    static class OnAssemblySubscriber<T>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final AssemblySnapshotException snapshotStack;
        final Publisher<?> parent;
        final CoreSubscriber<? super T> actual;
        Fuseable.QueueSubscription<T> qs;
        Subscription s;
        int fusionMode;

        OnAssemblySubscriber(CoreSubscriber<? super T> actual, AssemblySnapshotException snapshotStack, Publisher<?> parent) {
            this.actual = actual;
            this.snapshotStack = snapshotStack;
            this.parent = parent;
        }

        @Override
        public final CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL_METADATA) {
                return !this.snapshotStack.checkpointed;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        public String toString() {
            return this.snapshotStack.operatorAssemblyInformation();
        }

        @Override
        public String stepName() {
            return this.toString();
        }

        public final void onNext(T t) {
            this.actual.onNext(t);
        }

        public final void onError(Throwable t) {
            this.actual.onError(this.fail(t));
        }

        public final void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public final int requestFusion(int requestedMode) {
            Fuseable.QueueSubscription<T> qs = this.qs;
            if (qs != null) {
                int m = qs.requestFusion(requestedMode);
                if (m != 0) {
                    this.fusionMode = m;
                }
                return m;
            }
            return 0;
        }

        final Throwable fail(Throwable t) {
            StringBuilder sb = new StringBuilder();
            FluxOnAssembly.fillStacktraceHeader(sb, this.parent.getClass(), this.snapshotStack);
            OnAssemblyException set = null;
            if (!this.snapshotStack.isLight()) {
                sb.append(this.snapshotStack.toString());
            }
            if (t.getSuppressed().length > 0) {
                for (Throwable e : t.getSuppressed()) {
                    if (!(e instanceof OnAssemblyException)) continue;
                    OnAssemblyException oae = (OnAssemblyException)e;
                    oae.add(this.parent, sb.toString());
                    set = oae;
                    break;
                }
            }
            if (set == null) {
                t = Exceptions.addSuppressed(t, (Throwable)new OnAssemblyException(this.parent, this.snapshotStack, sb.toString()));
            } else if (this.snapshotStack.checkpointed) {
                t = Exceptions.addSuppressed(t, (Throwable)this.snapshotStack);
            }
            return t;
        }

        @Override
        public final boolean isEmpty() {
            try {
                return this.qs.isEmpty();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                throw Exceptions.propagate(this.fail(ex));
            }
        }

        @Override
        public final void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.qs = Operators.as(s);
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public final int size() {
            return this.qs.size();
        }

        @Override
        public final void clear() {
            this.qs.clear();
        }

        public final void request(long n) {
            this.s.request(n);
        }

        public final void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public final T poll() {
            try {
                return (T)this.qs.poll();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                throw Exceptions.propagate(this.fail(ex));
            }
        }
    }

    static final class OnAssemblyException
    extends RuntimeException {
        final List<Tuple3<Integer, String, Integer>> chainOrder = new LinkedList<Tuple3<Integer, String, Integer>>();
        private static final long serialVersionUID = 5278398300974016773L;

        OnAssemblyException(Publisher<?> parent, AssemblySnapshotException ase, String message) {
            super(message);
            if (!ase.isLight()) {
                this.chainOrder.add(Tuples.of(parent.hashCode(), Traces.extractOperatorAssemblyInformation(message, true), 0));
            }
        }

        void mapLine(int indent, StringBuilder sb, String s) {
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("\t|_\t").append(s).append("\n");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Publisher<?> parent, String stacktrace) {
            int key = FluxOnAssembly.getParentOrThis(Scannable.from(parent));
            List<Tuple3<Integer, String, Integer>> list = this.chainOrder;
            synchronized (list) {
                Tuple3<Integer, String, Integer> t;
                int i = 0;
                int n = this.chainOrder.size();
                for (int j = n - 1; j >= 0; --j) {
                    Tuple3<Integer, String, Integer> tmp = this.chainOrder.get(j);
                    if ((Integer)tmp.getT1() != key) continue;
                    i = tmp.getT3();
                    break;
                }
                while (true) {
                    if (!this.chainOrder.contains(t = Tuples.of(parent.hashCode(), Traces.extractOperatorAssemblyInformation(stacktrace, true), i))) break;
                    ++i;
                }
                this.chainOrder.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMessage() {
            List<Tuple3<Integer, String, Integer>> list = this.chainOrder;
            synchronized (list) {
                if (this.chainOrder.isEmpty()) {
                    return super.getMessage();
                }
                StringBuilder sb = new StringBuilder(super.getMessage()).append("Error has been observed by the following operator(s):\n");
                for (Tuple3<Integer, String, Integer> t : this.chainOrder) {
                    this.mapLine(t.getT3(), sb, (String)t.getT2());
                }
                return sb.toString();
            }
        }
    }

    static final class AssemblyLightSnapshotException
    extends AssemblySnapshotException {
        AssemblyLightSnapshotException(@Nullable String description) {
            super(description);
            this.cached = "checkpoint(\"" + description + "\")";
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public boolean isLight() {
            return true;
        }

        @Override
        String operatorAssemblyInformation() {
            return this.toString();
        }
    }

    static class AssemblySnapshotException
    extends RuntimeException {
        final boolean checkpointed;
        String cached;

        AssemblySnapshotException() {
            this.checkpointed = false;
        }

        AssemblySnapshotException(@Nullable String description) {
            super(description);
            this.checkpointed = true;
        }

        public boolean isLight() {
            return false;
        }

        @Override
        public String toString() {
            if (this.cached == null) {
                this.cached = FluxOnAssembly.getStacktrace(this);
            }
            return this.cached;
        }

        String operatorAssemblyInformation() {
            return Traces.extractOperatorAssemblyInformation(this.toString());
        }
    }
}

