/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.DefaultIdStrategy;
import io.protostuff.runtime.IdStrategy;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;

public final class RuntimeEnv {
    public static final boolean ENUMS_BY_NAME;
    public static final boolean AUTO_LOAD_POLYMORPHIC_CLASSES;
    public static final boolean ALLOW_NULL_ARRAY_ELEMENT;
    public static final boolean MORPH_NON_FINAL_POJOS;
    public static final boolean MORPH_COLLECTION_INTERFACES;
    public static final boolean MORPH_MAP_INTERFACES;
    public static final boolean COLLECTION_SCHEMA_ON_REPEATED_FIELDS;
    public static final boolean POJO_SCHEMA_ON_COLLECTION_FIELDS;
    public static final boolean POJO_SCHEMA_ON_MAP_FIELDS;
    public static final boolean USE_SUN_MISC_UNSAFE;
    static final Method newInstanceFromObjectInputStream;
    static final Method newInstanceFromObjectStreamClass;
    static final long objectConstructorId;
    static final boolean android43;
    static final Constructor<Object> OBJECT_CONSTRUCTOR;
    public static final IdStrategy ID_STRATEGY;

    private static Method getMethodNewInstanceFromObjectInputStream() {
        try {
            return ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Method getMethodNewInstanceFromObjectStreamClass(Number[] holder) {
        try {
            Method m43 = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Long.TYPE);
            Method mcid43 = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
            mcid43.setAccessible(true);
            holder[0] = (Number)mcid43.invoke(null, Object.class);
            return m43;
        }
        catch (Exception ex) {
            try {
                Method m = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Integer.TYPE);
                Method mcid = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                mcid.setAccessible(true);
                holder[0] = (Number)mcid.invoke(null, Object.class);
                return m;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static <T> Class<T> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Instantiator<T> newInstantiator(Class<T> clazz) {
        Constructor<T> constructor = RuntimeEnv.getConstructor(clazz);
        if (constructor == null) {
            if (android43) {
                return new Android43Instantiator<T>(clazz);
            }
            if (newInstanceFromObjectInputStream == null) {
                if (objectConstructorId == -1L) {
                    throw new RuntimeException("Could not resolve constructor for " + clazz);
                }
                return new Android3Instantiator<T>(clazz);
            }
            return new Android2Instantiator<T>(clazz);
        }
        return new DefaultInstantiator<T>(constructor);
    }

    private static <T> Constructor<T> getConstructor(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(null);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private RuntimeEnv() {
    }

    static {
        Constructor c = null;
        Class<?> reflectionFactoryClass = null;
        try {
            c = Object.class.getConstructor(null);
            reflectionFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("sun.reflect.ReflectionFactory");
        }
        catch (Exception e) {
            // empty catch block
        }
        OBJECT_CONSTRUCTOR = c != null && reflectionFactoryClass != null ? c : null;
        Method method = newInstanceFromObjectInputStream = OBJECT_CONSTRUCTOR == null ? RuntimeEnv.getMethodNewInstanceFromObjectInputStream() : null;
        if (newInstanceFromObjectInputStream != null) {
            newInstanceFromObjectInputStream.setAccessible(true);
            newInstanceFromObjectStreamClass = null;
            objectConstructorId = -1L;
            android43 = false;
        } else {
            Number[] holder = new Number[1];
            newInstanceFromObjectStreamClass = RuntimeEnv.getMethodNewInstanceFromObjectStreamClass(holder);
            if (newInstanceFromObjectStreamClass == null) {
                objectConstructorId = -1L;
                android43 = false;
            } else {
                objectConstructorId = holder[0].longValue();
                android43 = holder[0] instanceof Long;
            }
        }
        Properties props = OBJECT_CONSTRUCTOR == null ? new Properties() : System.getProperties();
        ENUMS_BY_NAME = Boolean.parseBoolean(props.getProperty("protostuff.runtime.enums_by_name", "false"));
        AUTO_LOAD_POLYMORPHIC_CLASSES = Boolean.parseBoolean(props.getProperty("protostuff.runtime.auto_load_polymorphic_classes", "true"));
        ALLOW_NULL_ARRAY_ELEMENT = Boolean.parseBoolean(props.getProperty("protostuff.runtime.allow_null_array_element", "false"));
        MORPH_NON_FINAL_POJOS = Boolean.parseBoolean(props.getProperty("protostuff.runtime.morph_non_final_pojos", "false"));
        MORPH_COLLECTION_INTERFACES = Boolean.parseBoolean(props.getProperty("protostuff.runtime.morph_collection_interfaces", "false"));
        MORPH_MAP_INTERFACES = Boolean.parseBoolean(props.getProperty("protostuff.runtime.morph_map_interfaces", "false"));
        COLLECTION_SCHEMA_ON_REPEATED_FIELDS = Boolean.parseBoolean(props.getProperty("protostuff.runtime.collection_schema_on_repeated_fields", "false"));
        POJO_SCHEMA_ON_COLLECTION_FIELDS = Boolean.parseBoolean(props.getProperty("protostuff.runtime.pojo_schema_on_collection_fields", "false"));
        POJO_SCHEMA_ON_MAP_FIELDS = Boolean.parseBoolean(props.getProperty("protostuff.runtime.pojo_schema_on_map_fields", "false"));
        USE_SUN_MISC_UNSAFE = OBJECT_CONSTRUCTOR != null && Boolean.parseBoolean(props.getProperty("protostuff.runtime.use_sun_misc_unsafe", "true"));
        String factoryProp = props.getProperty("protostuff.runtime.id_strategy_factory");
        if (factoryProp == null) {
            ID_STRATEGY = new DefaultIdStrategy();
        } else {
            IdStrategy.Factory factory;
            try {
                factory = (IdStrategy.Factory)RuntimeEnv.loadClass(factoryProp).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ID_STRATEGY = factory.create();
            factory.postCreate();
        }
    }

    static final class Android43Instantiator<T>
    extends Instantiator<T> {
        final Class<T> clazz;

        Android43Instantiator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T newInstance() {
            try {
                return (T)newInstanceFromObjectStreamClass.invoke(null, this.clazz, objectConstructorId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class Android3Instantiator<T>
    extends Instantiator<T> {
        final Class<T> clazz;

        Android3Instantiator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T newInstance() {
            try {
                return (T)newInstanceFromObjectStreamClass.invoke(null, this.clazz, (int)objectConstructorId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class Android2Instantiator<T>
    extends Instantiator<T> {
        final Class<T> clazz;

        Android2Instantiator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T newInstance() {
            try {
                return (T)newInstanceFromObjectInputStream.invoke(null, this.clazz, Object.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DefaultInstantiator<T>
    extends Instantiator<T> {
        final Constructor<T> constructor;

        DefaultInstantiator(Constructor<T> constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        @Override
        public T newInstance() {
            try {
                return this.constructor.newInstance(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class Instantiator<T> {
        public abstract T newInstance();
    }
}

