/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.runtime.Field;
import io.protostuff.runtime.Predicate;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class RuntimeView {
    private RuntimeView() {
    }

    public static <T> Schema<T> createFrom(RuntimeSchema<T> rs, Factory vf, Predicate.Factory pf, String ... args) {
        return RuntimeView.createFrom(rs, rs.instantiator, vf, pf, args);
    }

    public static <T> Schema<T> createFrom(RuntimeSchema<T> ms, RuntimeEnv.Instantiator<T> instantiator, Factory vf, Predicate.Factory pf, String ... args) {
        return vf.create(ms, instantiator, pf, args);
    }

    static <T> HashMap<String, Field<T>> copyAndExclude(Class<? super T> typeClass, List<Field<T>> fields, Predicate predicate) {
        HashMap<String, Field<T>> map = new HashMap<String, Field<T>>();
        for (Field<T> field : fields) {
            if (predicate.apply(field)) continue;
            map.put(field.name, field);
        }
        return map;
    }

    static <T> HashMap<String, Field<T>> copyAndExclude(Class<? super T> typeClass, List<Field<T>> fields, String[] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("You must provide at least 1 field to exclude.");
        }
        HashMap<String, Field<T>> map = new HashMap<String, Field<T>>();
        HashSet exclude = new HashSet();
        Collections.addAll(exclude, args);
        for (Field<T> field : fields) {
            if (exclude.contains(field.name)) continue;
            map.put(field.name, field);
        }
        return map;
    }

    static <T> int includeAndAddTo(Map<String, Field<T>> map, Class<? super T> typeClass, List<Field<T>> fields, String[] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("You must provide at least 1 field to include.");
        }
        int maxFieldNumber = 0;
        HashSet include = new HashSet();
        Collections.addAll(include, args);
        for (Field<T> field : fields) {
            if (!include.contains(field.name)) continue;
            map.put(field.name, field);
            maxFieldNumber = Math.max(field.number, maxFieldNumber);
        }
        return maxFieldNumber;
    }

    public static enum Factories implements Factory
    {
        PREDICATE{

            @Override
            public <T> Schema<T> create(final RuntimeSchema<T> ms, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory pf, String[] args) {
                if (pf == null) {
                    throw new IllegalArgumentException("Predicate.Factory arg must not be null.");
                }
                final Predicate predicate = pf.create(args);
                return new BaseSchema<T>(ms.typeClass(), instantiator){

                    public int getFieldNumber(String name) {
                        Field field = ms.getFieldByName(name);
                        return field != null && predicate.apply(field) ? field.number : 0;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            Field field = ms.getFieldByNumber(number);
                            if (field == null || !predicate.apply(field, message)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        Field field = ms.getFieldByNumber(number);
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (Field f : ms.getFields()) {
                            if (!predicate.apply(f, message)) continue;
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        }
        ,
        EXCLUDE{

            @Override
            public <T> Schema<T> create(final RuntimeSchema<T> ms, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory factory, String[] args) {
                final HashMap fieldsByName = factory == null ? RuntimeView.copyAndExclude(ms.typeClass(), ms.getFields(), args) : RuntimeView.copyAndExclude(ms.typeClass(), ms.getFields(), factory.create(args));
                Field[] fields = new Field[fieldsByName.size()];
                int i = 0;
                for (Field field : fieldsByName.values()) {
                    fields[i++] = field;
                }
                return new PostFilteredSchema<T>(ms.typeClass(), instantiator, fields){

                    public int getFieldNumber(String name) {
                        Field field = (Field)fieldsByName.get(name);
                        return field == null ? 0 : field.number;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            Field field = ms.getFieldByNumber(number);
                            if (field == null || !fieldsByName.containsKey(field.name)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        Field field = ms.getFieldByNumber(number);
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (Field f : this.fields) {
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        }
        ,
        EXCLUDE_OPTIMIZED_FOR_MERGE_ONLY{

            @Override
            public <T> Schema<T> create(RuntimeSchema<T> ms, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory pf, String[] args) {
                return EXCLUDE.create(ms, instantiator, pf, args);
            }
        }
        ,
        INCLUDE{

            @Override
            public <T> Schema<T> create(final RuntimeSchema<T> ms, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory factory, String[] args) {
                final HashMap fieldsByName = new HashMap();
                int maxFieldNumber = RuntimeView.includeAndAddTo(fieldsByName, ms.typeClass(), ms.getFields(), args);
                Field[] fields = new Field[fieldsByName.size()];
                int i = 0;
                for (Field field : fieldsByName.values()) {
                    fields[i++] = field;
                }
                return new PostFilteredSchema<T>(ms.typeClass(), instantiator, fields){

                    public int getFieldNumber(String name) {
                        Field field = (Field)fieldsByName.get(name);
                        return field == null ? 0 : field.number;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            Field field = ms.getFieldByNumber(number);
                            if (field == null || !fieldsByName.containsKey(field.name)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        Field field = ms.getFieldByNumber(number);
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (Field f : this.fields) {
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        }
        ,
        INCLUDE_OPTIMIZED_FOR_MERGE_ONLY{

            @Override
            public <T> Schema<T> create(RuntimeSchema<T> ms, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory pf, String[] args) {
                return INCLUDE.create(ms, instantiator, pf, args);
            }
        };

    }

    public static abstract class PostFilteredSchema<T>
    extends BaseSchema<T> {
        public final Field<T>[] fields;

        protected PostFilteredSchema(Class<? super T> typeClass, RuntimeEnv.Instantiator<T> instantiator, Field<T>[] fields) {
            super(typeClass, instantiator);
            this.fields = fields;
        }
    }

    public static abstract class BaseSchema<T>
    implements Schema<T> {
        public final Class<? super T> typeClass;
        public final RuntimeEnv.Instantiator<T> instantiator;

        protected BaseSchema(Class<? super T> typeClass, RuntimeEnv.Instantiator<T> instantiator) {
            this.typeClass = typeClass;
            this.instantiator = instantiator;
        }

        public Class<? super T> typeClass() {
            return this.typeClass;
        }

        public String messageName() {
            return this.typeClass.getSimpleName();
        }

        public String messageFullName() {
            return this.typeClass.getName();
        }

        public boolean isInitialized(T message) {
            return true;
        }

        public T newMessage() {
            return (T)this.instantiator.newInstance();
        }
    }

    public static interface Factory {
        public <T> Schema<T> create(RuntimeSchema<T> var1, RuntimeEnv.Instantiator<T> var2, Predicate.Factory var3, String[] var4);
    }
}

