/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractJsonCodec;
import io.r2dbc.postgresql.codec.Json;
import io.r2dbc.postgresql.codec.JsonInputStreamCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class JsonCodec
extends AbstractJsonCodec<Json> {
    private final ByteBufAllocator byteBufAllocator;
    private final boolean preferAttachedBuffers;

    JsonCodec(ByteBufAllocator byteBufAllocator, boolean preferAttachedBuffers) {
        super(Json.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.preferAttachedBuffers = preferAttachedBuffers;
    }

    @Override
    Json doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends Json> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (dataType == PostgresqlObjectId.JSONB && format == Format.FORMAT_BINARY) {
            buffer.skipBytes(1);
        }
        if (this.preferAttachedBuffers) {
            return new Json.JsonOutput(buffer.retainedSlice());
        }
        return new Json.JsonByteArrayInput(ByteBufUtil.getBytes((ByteBuf)buffer));
    }

    @Override
    Parameter doEncode(Json value) {
        Assert.requireNonNull(value, "value must not be null");
        if (!(value instanceof Json.JsonInput) && !(value instanceof Json.JsonOutput)) {
            throw new IllegalArgumentException("value must be JsonInput or JsonOutput");
        }
        return JsonCodec.create(PostgresqlObjectId.JSONB, Format.FORMAT_BINARY, () -> {
            Object toEncode;
            if (value instanceof Json.JsonInput) {
                toEncode = ((Json.JsonInput)value).value;
            } else {
                toEncode = ((Json.JsonOutput)value).buffer;
                ((Json.JsonOutput)value).released = true;
            }
            if (toEncode instanceof InputStream) {
                return JsonInputStreamCodec.doEncode((InputStream)toEncode, this.byteBufAllocator);
            }
            if (toEncode instanceof String) {
                toEncode = ByteBufUtils.encode(this.byteBufAllocator, (String)toEncode);
            }
            if (toEncode instanceof ByteBuffer) {
                toEncode = Unpooled.wrappedBuffer((ByteBuffer)((ByteBuffer)toEncode));
            }
            if (toEncode instanceof byte[]) {
                toEncode = Unpooled.wrappedBuffer((byte[])((byte[])toEncode));
            }
            ByteBuf buffer = (ByteBuf)toEncode;
            buffer.touch();
            try {
                ByteBuf byteBuf = this.byteBufAllocator.buffer(buffer.readableBytes() + 1).writeByte(1).writeBytes(buffer);
                return byteBuf;
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)buffer);
            }
        });
    }
}

