/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.net.Address;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.ServiceRegistration;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class ServiceEndpoint
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Address address;
    private Set<String> contentTypes;
    private Map<String, String> tags;
    private Collection<ServiceRegistration> serviceRegistrations;

    @Deprecated
    public ServiceEndpoint() {
    }

    private ServiceEndpoint(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "ServiceEndpoint.id is required");
        this.address = Objects.requireNonNull(builder.address, "ServiceEndpoint.address is required");
        this.contentTypes = Collections.unmodifiableSet(new HashSet(builder.contentTypes));
        this.tags = Collections.unmodifiableMap(new HashMap(builder.tags));
        this.serviceRegistrations = Collections.unmodifiableList(new ArrayList(builder.serviceRegistrations));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(ServiceEndpoint serviceEndpoint) {
        return new Builder(serviceEndpoint);
    }

    public String id() {
        return this.id;
    }

    public Address address() {
        return this.address;
    }

    public Set<String> contentTypes() {
        return this.contentTypes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Collection<ServiceRegistration> serviceRegistrations() {
        return this.serviceRegistrations;
    }

    public Collection<ServiceReference> serviceReferences() {
        return this.serviceRegistrations.stream().flatMap(sr -> sr.methods().stream().map(sm -> new ServiceReference((ServiceMethodDefinition)sm, (ServiceRegistration)sr, this))).collect(Collectors.toList());
    }

    public String toString() {
        return new StringJoiner(", ", ServiceEndpoint.class.getSimpleName() + "[", "]").add("id=" + this.id).add("address=" + this.address).add("contentTypes=" + this.contentTypes).add("tags=" + this.tags).add("serviceRegistrations(" + this.serviceRegistrations.size() + ")").toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeUTF(this.address.toString());
        out.writeInt(this.contentTypes.size());
        for (String string : this.contentTypes) {
            out.writeUTF(string);
        }
        out.writeInt(this.tags.size());
        for (Map.Entry entry : this.tags.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.serviceRegistrations.size());
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
            out.writeObject(serviceRegistration);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.address = Address.from((String)in.readUTF());
        int contentTypesSize = in.readInt();
        HashSet<String> contentTypes = new HashSet<String>(contentTypesSize);
        for (int i = 0; i < contentTypesSize; ++i) {
            contentTypes.add(in.readUTF());
        }
        this.contentTypes = Collections.unmodifiableSet(contentTypes);
        int tagsSize = in.readInt();
        HashMap<String, String> tags = new HashMap<String, String>(tagsSize);
        for (int i = 0; i < tagsSize; ++i) {
            String key = in.readUTF();
            String value = (String)in.readObject();
            tags.put(key, value);
        }
        this.tags = Collections.unmodifiableMap(tags);
        int serviceRegistrationsSize = in.readInt();
        ArrayList<ServiceRegistration> serviceRegistrations = new ArrayList<ServiceRegistration>(serviceRegistrationsSize);
        for (int i = 0; i < serviceRegistrationsSize; ++i) {
            serviceRegistrations.add((ServiceRegistration)in.readObject());
        }
        this.serviceRegistrations = Collections.unmodifiableList(serviceRegistrations);
    }

    public static class Builder {
        private String id;
        private Address address = Address.NULL_ADDRESS;
        private Set<String> contentTypes = Collections.emptySet();
        private Map<String, String> tags = Collections.emptyMap();
        private Collection<ServiceRegistration> serviceRegistrations = new ArrayList<ServiceRegistration>();

        private Builder() {
        }

        private Builder(ServiceEndpoint other) {
            this.id = other.id;
            this.address = other.address;
            this.contentTypes = new HashSet<String>(other.contentTypes);
            this.tags = new HashMap<String, String>(other.tags);
            this.serviceRegistrations = new ArrayList<ServiceRegistration>(other.serviceRegistrations);
        }

        public Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        public Builder address(Address address) {
            this.address = Objects.requireNonNull(address, "address");
            return this;
        }

        public Builder contentTypes(Set<String> contentTypes) {
            this.contentTypes = new HashSet<String>((Collection)Objects.requireNonNull(contentTypes, "contentTypes"));
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = new HashMap<String, String>(Objects.requireNonNull(tags, "tags"));
            return this;
        }

        public Builder appendServiceRegistrations(Collection<ServiceRegistration> serviceRegistrations) {
            this.serviceRegistrations.addAll(Objects.requireNonNull(serviceRegistrations, "serviceRegistrations"));
            return this;
        }

        public Builder serviceRegistrations(Collection<ServiceRegistration> serviceRegistrations) {
            this.serviceRegistrations = new ArrayList<ServiceRegistration>(Objects.requireNonNull(serviceRegistrations, "serviceRegistrations"));
            return this;
        }

        public ServiceEndpoint build() {
            return new ServiceEndpoint(this);
        }
    }
}

