/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.auth.PrincipalMapper;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.transport.api.ServiceMessageDataDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class ServiceInfo {
    private final Object serviceInstance;
    private final Map<String, String> tags;
    private final ServiceProviderErrorMapper errorMapper;
    private final ServiceMessageDataDecoder dataDecoder;
    private final Authenticator<Object> authenticator;
    private final PrincipalMapper<Object, Object> principalMapper;

    private ServiceInfo(Builder builder) {
        this.serviceInstance = builder.serviceInstance;
        this.tags = Collections.unmodifiableMap(new HashMap(builder.tags));
        this.errorMapper = builder.errorMapper;
        this.dataDecoder = builder.dataDecoder;
        this.authenticator = builder.authenticator;
        this.principalMapper = builder.principalMapper;
    }

    public static Builder from(ServiceInfo serviceInfo) {
        return new Builder(serviceInfo);
    }

    public static Builder fromServiceInstance(Object serviceInstance) {
        return new Builder(serviceInstance);
    }

    public Object serviceInstance() {
        return this.serviceInstance;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServiceProviderErrorMapper errorMapper() {
        return this.errorMapper;
    }

    public ServiceMessageDataDecoder dataDecoder() {
        return this.dataDecoder;
    }

    public Authenticator<Object> authenticator() {
        return this.authenticator;
    }

    public PrincipalMapper<Object, Object> principalMapper() {
        return this.principalMapper;
    }

    public String toString() {
        return new StringJoiner(", ", ServiceInfo.class.getSimpleName() + "[", "]").add("serviceInstance=" + this.serviceInstance).add("tags(" + this.tags.size() + ")").add("errorMapper=" + this.errorMapper).add("dataDecoder=" + this.dataDecoder).add("authenticator=" + this.authenticator).add("principalMapper=" + this.principalMapper).toString();
    }

    public static class Builder {
        private final Object serviceInstance;
        private final Map<String, String> tags = new HashMap<String, String>();
        private ServiceProviderErrorMapper errorMapper;
        private ServiceMessageDataDecoder dataDecoder;
        private Authenticator<Object> authenticator;
        private PrincipalMapper<Object, Object> principalMapper;

        private Builder(ServiceInfo serviceInfo) {
            this.serviceInstance = serviceInfo.serviceInstance;
            this.tags.putAll(new HashMap(serviceInfo.tags));
            this.errorMapper = serviceInfo.errorMapper;
            this.dataDecoder = serviceInfo.dataDecoder;
            this.authenticator = serviceInfo.authenticator;
            this.principalMapper = serviceInfo.principalMapper;
        }

        private Builder(Object serviceInstance) {
            this.serviceInstance = serviceInstance;
        }

        public Builder tag(String key, String value) {
            Objects.requireNonNull(key, "tag key");
            Objects.requireNonNull(value, "tag value");
            this.tags.put(key, value);
            return this;
        }

        public Builder errorMapper(ServiceProviderErrorMapper errorMapper) {
            this.errorMapper = Objects.requireNonNull(errorMapper, "errorMapper");
            return this;
        }

        public Builder dataDecoder(ServiceMessageDataDecoder dataDecoder) {
            this.dataDecoder = Objects.requireNonNull(dataDecoder, "dataDecoder");
            return this;
        }

        public <T> Builder authenticator(Authenticator<? extends T> authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public <T, R> Builder principalMapper(PrincipalMapper<? super T, ? extends R> principalMapper) {
            this.principalMapper = principalMapper;
            return this;
        }

        Builder errorMapperIfAbsent(ServiceProviderErrorMapper errorMapper) {
            if (this.errorMapper == null) {
                this.errorMapper = errorMapper;
            }
            return this;
        }

        Builder dataDecoderIfAbsent(ServiceMessageDataDecoder dataDecoder) {
            if (this.dataDecoder == null) {
                this.dataDecoder = dataDecoder;
            }
            return this;
        }

        Builder authenticatorIfAbsent(Authenticator<Object> authenticator) {
            if (this.authenticator == null) {
                this.authenticator = authenticator;
            }
            return this;
        }

        Builder principalMapperIfAbsent(PrincipalMapper<Object, Object> principalMapper) {
            if (this.principalMapper == null) {
                this.principalMapper = principalMapper;
            }
            return this;
        }

        public ServiceInfo build() {
            return new ServiceInfo(this);
        }
    }
}

