/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery.api;

import io.scalecube.net.Address;
import io.scalecube.services.discovery.api.ServiceDiscovery;
import io.scalecube.services.discovery.api.ServiceDiscoveryEvent;
import io.scalecube.services.registry.api.ServiceRegistry;
import java.util.Objects;
import java.util.StringJoiner;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;

public final class ServiceDiscoveryContext {
    private final String id;
    private final Address address;
    private final ServiceDiscovery discovery;
    private final ServiceRegistry serviceRegistry;
    private final Scheduler scheduler;

    private ServiceDiscoveryContext(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.address = Objects.requireNonNull(builder.address, "address");
        this.discovery = Objects.requireNonNull(builder.discovery, "discovery");
        this.serviceRegistry = Objects.requireNonNull(builder.serviceRegistry, "serviceRegistry");
        this.scheduler = Objects.requireNonNull(builder.scheduler, "scheduler");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(ServiceDiscoveryContext other) {
        return new Builder().id(other.id).address(other.address).discovery(other.discovery).serviceRegistry(other.serviceRegistry).scheduler(other.scheduler);
    }

    public String id() {
        return this.id;
    }

    public Address address() {
        return this.address;
    }

    public Flux<ServiceDiscoveryEvent> listen() {
        return Flux.fromStream(this.serviceRegistry.listServiceEndpoints().stream()).map(ServiceDiscoveryEvent::newEndpointAdded).concatWith(this.discovery.listen()).subscribeOn(this.scheduler).publishOn(this.scheduler);
    }

    public String toString() {
        return new StringJoiner(", ", ServiceDiscoveryContext.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("address=" + this.address).add("discovery=" + this.discovery).add("serviceRegistry=" + this.serviceRegistry).add("scheduler=" + this.scheduler).toString();
    }

    public static class Builder {
        private String id;
        private Address address;
        private ServiceDiscovery discovery;
        private ServiceRegistry serviceRegistry;
        private Scheduler scheduler;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder discovery(ServiceDiscovery discovery) {
            this.discovery = discovery;
            return this;
        }

        public Builder serviceRegistry(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public ServiceDiscoveryContext build() {
            return new ServiceDiscoveryContext(this);
        }
    }
}

