/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway;

import io.scalecube.services.ServiceCall;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class GatewayOptions {
    private String id;
    private int port = 0;
    private Executor workerPool;
    private ServiceCall call;

    public GatewayOptions() {
    }

    public GatewayOptions(GatewayOptions other) {
        this.id = other.id;
        this.port = other.port;
        this.workerPool = other.workerPool;
        this.call = other.call;
    }

    private GatewayOptions set(Consumer<GatewayOptions> c) {
        GatewayOptions s = new GatewayOptions(this);
        c.accept(s);
        return s;
    }

    public GatewayOptions id(String id) {
        return this.set(o -> {
            o.id = id;
        });
    }

    public String id() {
        return this.id;
    }

    public GatewayOptions port(int port) {
        return this.set(o -> {
            o.port = port;
        });
    }

    public int port() {
        return this.port;
    }

    public GatewayOptions workerPool(Executor workerPool) {
        return this.set(o -> {
            o.workerPool = workerPool;
        });
    }

    public Executor workerPool() {
        return this.workerPool;
    }

    public GatewayOptions call(ServiceCall call) {
        return this.set(o -> {
            o.call = call;
        });
    }

    public ServiceCall call() {
        return this.call;
    }

    public String toString() {
        return new StringJoiner(", ", GatewayOptions.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("port=" + this.port).add("workerPool=" + this.workerPool).add("call=" + this.call).toString();
    }
}

