/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.codec;

public enum CodecType {
    SEATA(1),
    PROTOBUF(2),
    KRYO(4);

    private final byte code;

    private CodecType(byte code) {
        this.code = code;
    }

    public static CodecType getByCode(int code) {
        for (CodecType b : CodecType.values()) {
            if (code != b.code) continue;
            return b;
        }
        throw new IllegalArgumentException("unknown codec:" + code);
    }

    public static CodecType getByName(String name) {
        for (CodecType b : CodecType.values()) {
            if (!b.name().equalsIgnoreCase(name)) continue;
            return b;
        }
        throw new IllegalArgumentException("unknown codec:" + name);
    }

    public byte getCode() {
        return this.code;
    }
}

