/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.ParametersHolder;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.Executor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.SQLRecognizer;
import io.seata.rm.datasource.sql.SQLType;
import io.seata.rm.datasource.sql.WhereRecognizer;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public abstract class BaseTransactionalExecutor<T, S extends Statement>
implements Executor {
    protected StatementProxy<S> statementProxy;
    protected StatementCallback<T, S> statementCallback;
    protected SQLRecognizer sqlRecognizer;
    private TableMeta tableMeta;

    public BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizer = sqlRecognizer;
    }

    public Object execute(Object ... args) throws Throwable {
        if (RootContext.inGlobalTransaction()) {
            String xid = RootContext.getXID();
            this.statementProxy.getConnectionProxy().bind(xid);
        }
        if (RootContext.requireGlobalLock()) {
            this.statementProxy.getConnectionProxy().setGlobalLockRequire(true);
        } else {
            this.statementProxy.getConnectionProxy().setGlobalLockRequire(false);
        }
        return this.doExecute(args);
    }

    protected abstract Object doExecute(Object ... var1) throws Throwable;

    protected String buildWhereConditionByPKs(List<Field> pkRows) throws SQLException {
        StringJoiner whereConditionAppender = new StringJoiner(" OR ");
        for (Field field : pkRows) {
            whereConditionAppender.add(this.getColumnNameInSQL(field.getName()) + " = ?");
        }
        return whereConditionAppender.toString();
    }

    protected String buildWhereCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String whereCondition = null;
        whereCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getWhereCondition((ParametersHolder)((Object)this.statementProxy), paramAppenderList) : recognizer.getWhereCondition();
        if (StringUtils.isNotBlank(whereCondition) && CollectionUtils.isNotEmpty(paramAppenderList) && paramAppenderList.size() > 1) {
            StringBuilder whereConditionSb = new StringBuilder();
            whereConditionSb.append(" ( ").append(whereCondition).append(" ) ");
            for (int i = 1; i < paramAppenderList.size(); ++i) {
                whereConditionSb.append(" or ( ").append(whereCondition).append(" ) ");
            }
            whereCondition = whereConditionSb.toString();
        }
        return whereCondition;
    }

    protected String getColumnNameInSQL(String columnName) {
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? columnName : tableAlias + "." + columnName;
    }

    protected String getFromTableInSQL() {
        String tableName = this.sqlRecognizer.getTableName();
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? tableName : tableName + " " + tableAlias;
    }

    protected TableMeta getTableMeta() {
        return this.getTableMeta(this.sqlRecognizer.getTableName());
    }

    protected TableMeta getTableMeta(String tableName) {
        if (this.tableMeta != null) {
            return this.tableMeta;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        this.tableMeta = TableMetaCacheFactory.getTableMetaCache(connectionProxy.getDbType()).getTableMeta(connectionProxy.getDataSourceProxy(), tableName);
        return this.tableMeta;
    }

    protected void prepareUndoLog(TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (beforeImage.getRows().size() == 0 && afterImage.getRows().size() == 0) {
            return;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        TableRecords lockKeyRecords = this.sqlRecognizer.getSQLType() == SQLType.DELETE ? beforeImage : afterImage;
        String lockKeys = this.buildLockKey(lockKeyRecords);
        connectionProxy.appendLockKey(lockKeys);
        SQLUndoLog sqlUndoLog = this.buildUndoItem(beforeImage, afterImage);
        connectionProxy.appendUndoLog(sqlUndoLog);
    }

    protected String buildLockKey(TableRecords rowsIncludingPK) {
        if (rowsIncludingPK.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rowsIncludingPK.getTableMeta().getTableName());
        sb.append(":");
        int filedSequence = 0;
        for (Field field : rowsIncludingPK.pkRows()) {
            sb.append(field.getValue());
            if (++filedSequence >= rowsIncludingPK.pkRows().size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected SQLUndoLog buildUndoItem(TableRecords beforeImage, TableRecords afterImage) {
        SQLType sqlType = this.sqlRecognizer.getSQLType();
        String tableName = this.sqlRecognizer.getTableName();
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords buildTableRecords(TableMeta tableMeta, String selectSQL, ArrayList<List<Object>> paramAppenderList) throws SQLException {
        TableRecords tableRecords = null;
        Statement ps = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            if (paramAppenderList.isEmpty()) {
                st = this.statementProxy.getConnection().createStatement();
                rs = st.executeQuery(selectSQL);
            } else {
                if (paramAppenderList.size() == 1) {
                    ps = this.statementProxy.getConnection().prepareStatement(selectSQL);
                    List<Object> paramAppender = paramAppenderList.get(0);
                    for (int i = 0; i < paramAppender.size(); ++i) {
                        ps.setObject(i + 1, paramAppender.get(i));
                    }
                } else {
                    ps = this.statementProxy.getConnection().prepareStatement(selectSQL);
                    List<Object> paramAppender = null;
                    for (int i = 0; i < paramAppenderList.size(); ++i) {
                        paramAppender = paramAppenderList.get(i);
                        for (int j = 0; j < paramAppender.size(); ++j) {
                            ps.setObject(i * paramAppender.size() + j + 1, paramAppender.get(j));
                        }
                    }
                }
                rs = ps.executeQuery();
            }
            tableRecords = TableRecords.buildRecords(tableMeta, rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return tableRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords buildTableRecords(List<Object> pkValues) throws SQLException {
        TableRecords afterImage;
        String pk = this.getTableMeta().getPkName();
        StringJoiner pkValuesJoiner = new StringJoiner(" OR ", "SELECT * FROM " + this.getTableMeta().getTableName() + " WHERE ", "");
        for (Object pkValue : pkValues) {
            pkValuesJoiner.add(pk + "=?");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.statementProxy.getConnection().prepareStatement(pkValuesJoiner.toString());
            for (int i = 1; i <= pkValues.size(); ++i) {
                ps.setObject(i, pkValues.get(i - 1));
            }
            rs = ps.executeQuery();
            afterImage = TableRecords.buildRecords(this.getTableMeta(), rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return afterImage;
    }

    protected String getDbType() {
        return this.statementProxy.getConnectionProxy().getDbType();
    }
}

