/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableMetaCache;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableMetaCache
implements TableMetaCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTableMetaCache.class);
    private static final long CACHE_SIZE = 100000L;
    private static final long EXPIRE_TIME = 900000L;
    private static final Cache<String, TableMeta> TABLE_META_CACHE = Caffeine.newBuilder().maximumSize(100000L).expireAfterWrite(900000L, TimeUnit.MILLISECONDS).softValues().build();

    @Override
    public TableMeta getTableMeta(DataSourceProxy dataSourceProxy, String tableName) {
        if (StringUtils.isNullOrEmpty(tableName)) {
            throw new IllegalArgumentException("TableMeta cannot be fetched without tableName");
        }
        String key = this.getCacheKey(dataSourceProxy, tableName);
        TableMeta tmeta = (TableMeta)TABLE_META_CACHE.get((Object)key, mappingFunction -> {
            try {
                return this.fetchSchema(dataSourceProxy.getTargetDataSource(), tableName);
            }
            catch (SQLException e) {
                LOGGER.error("get cache error:{}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        });
        if (tmeta == null) {
            try {
                tmeta = this.fetchSchema(dataSourceProxy.getTargetDataSource(), tableName);
            }
            catch (SQLException e) {
                LOGGER.error("get table meta error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (tmeta == null) {
            throw new ShouldNeverHappenException(String.format("[xid:%s]get tablemeta failed", RootContext.getXID()));
        }
        return tmeta;
    }

    @Override
    public void refresh(DataSourceProxy dataSourceProxy) {
        ConcurrentMap tableMetaMap = TABLE_META_CACHE.asMap();
        for (Map.Entry entry : tableMetaMap.entrySet()) {
            String key = this.getCacheKey(dataSourceProxy, ((TableMeta)entry.getValue()).getTableName());
            if (!((String)entry.getKey()).equals(key)) continue;
            try {
                TableMeta tableMeta = this.fetchSchema(dataSourceProxy, ((TableMeta)entry.getValue()).getTableName());
                if (tableMeta.equals(entry.getValue())) continue;
                TABLE_META_CACHE.put(entry.getKey(), (Object)tableMeta);
                LOGGER.info("table meta change was found, update table meta cache automatically.");
            }
            catch (SQLException e) {
                LOGGER.error("get table meta error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private String getCacheKey(DataSourceProxy dataSourceProxy, String tableName) {
        return dataSourceProxy.getResourceId() + "." + tableName;
    }

    protected abstract TableMeta fetchSchema(DataSource var1, String var2) throws SQLException;
}

