/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.config;

import io.seata.saga.engine.impl.DefaultStateMachineConfig;
import io.seata.saga.engine.store.db.DbAndReportTcStateLogStore;
import io.seata.saga.engine.store.db.DbStateLangStore;
import io.seata.saga.tm.DefaultSagaTransactionalTemplate;
import io.seata.saga.tm.SagaTransactionalTemplate;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DbStateMachineConfig
extends DefaultStateMachineConfig
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbStateMachineConfig.class);
    private static final int DEFAULT_TRANS_OPER_TIMEOUT = 600000;
    private DataSource dataSource;
    private String applicationId;
    private String txServiceGroup;
    private String tablePrefix = "seata_";
    private String dbType;
    private int transOperationTimeout = 600000;
    private SagaTransactionalTemplate sagaTransactionalTemplate;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.dbType = DbStateMachineConfig.getDbTypeFromDataSource(this.dataSource);
        if (this.getStateLogStore() == null) {
            DbAndReportTcStateLogStore dbStateLogStore = new DbAndReportTcStateLogStore();
            dbStateLogStore.setDataSource(this.dataSource);
            dbStateLogStore.setTablePrefix(this.tablePrefix);
            dbStateLogStore.setDbType(this.dbType);
            dbStateLogStore.setDefaultTenantId(this.getDefaultTenantId());
            dbStateLogStore.setSeqGenerator(this.getSeqGenerator());
            if (this.sagaTransactionalTemplate == null) {
                DefaultSagaTransactionalTemplate defaultSagaTransactionalTemplate = new DefaultSagaTransactionalTemplate();
                defaultSagaTransactionalTemplate.setTimeout(this.transOperationTimeout);
                defaultSagaTransactionalTemplate.setApplicationContext(this.getApplicationContext());
                defaultSagaTransactionalTemplate.setApplicationId(this.applicationId);
                defaultSagaTransactionalTemplate.setTxServiceGroup(this.txServiceGroup);
                defaultSagaTransactionalTemplate.afterPropertiesSet();
                this.sagaTransactionalTemplate = defaultSagaTransactionalTemplate;
            }
            dbStateLogStore.setSagaTransactionalTemplate(this.sagaTransactionalTemplate);
            this.setStateLogStore(dbStateLogStore);
        }
        if (this.getStateLangStore() == null) {
            DbStateLangStore dbStateLangStore = new DbStateLangStore();
            dbStateLangStore.setDataSource(this.dataSource);
            dbStateLangStore.setTablePrefix(this.tablePrefix);
            dbStateLangStore.setDbType(this.dbType);
            this.setStateLangStore(dbStateLangStore);
        }
    }

    public void destroy() throws Exception {
        if (this.sagaTransactionalTemplate != null && this.sagaTransactionalTemplate instanceof DisposableBean) {
            ((DisposableBean)this.sagaTransactionalTemplate).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDbTypeFromDataSource(DataSource dataSource) throws SQLException {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Get dbType from failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTxServiceGroup() {
        return this.txServiceGroup;
    }

    public void setTxServiceGroup(String txServiceGroup) {
        this.txServiceGroup = txServiceGroup;
    }

    public void setSagaTransactionalTemplate(SagaTransactionalTemplate sagaTransactionalTemplate) {
        this.sagaTransactionalTemplate = sagaTransactionalTemplate;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public int getTransOperationTimeout() {
        return this.transOperationTimeout;
    }

    public void setTransOperationTimeout(int transOperationTimeout) {
        this.transOperationTimeout = transOperationTimeout;
    }
}

