/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.handlers;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.StateMachineEngine;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.exception.ForwardInvalidException;
import io.seata.saga.engine.pcext.InterceptibleStateHandler;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.handlers.ServiceTaskStateHandler;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.store.StateLogStore;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.SubStateMachine;
import io.seata.saga.statelang.domain.impl.SubStateMachineImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SubStateMachineHandler
implements StateHandler,
InterceptibleStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubStateMachineHandler.class);
    private List<StateHandlerInterceptor> interceptors;

    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        SubStateMachineImpl subStateMachine = (SubStateMachineImpl)instruction.getState(context);
        StateMachineEngine engine = (StateMachineEngine)context.getVariable("_current_statemachine_engine_");
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateInstance stateInstance = (StateInstance)context.getVariable("_current_state_instance_");
        Object inputParamsObj = context.getVariable("inputParams");
        HashMap<String, Object> startParams = new HashMap<String, String>(0);
        if (inputParamsObj instanceof List) {
            List listInputParams = (List)inputParamsObj;
            if (listInputParams.size() > 0) {
                startParams = (Map)listInputParams.get(0);
            }
        } else if (inputParamsObj instanceof Map) {
            startParams = (Map)inputParamsObj;
        }
        startParams.put("_parent_id_", EngineUtils.generateParentId(stateInstance));
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(">>>>>>>>>>>>>>>>>>>>>> Start to execute SubStateMachine [" + subStateMachine.getStateMachineName() + "] by state[" + subStateMachine.getName() + "]");
            }
            StateMachineInstance subStateMachineInstance = this.callSubStateMachine(startParams, engine, context, stateInstance, subStateMachine);
            Map<String, Object> outputParams = subStateMachineInstance.getEndParams();
            boolean isForward = "_operation_name_".equals(context.getVariable("_operation_name_"));
            ExecutionStatus callSubMachineStatus = SubStateMachineHandler.decideStatus(subStateMachineInstance, isForward);
            stateInstance.setStatus(callSubMachineStatus);
            outputParams.put("_sub_statemachine_execution_status_", callSubMachineStatus.toString());
            context.setVariable("outputParams", outputParams);
            stateInstance.setOutputParams(outputParams);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("<<<<<<<<<<<<<<<<<<<<<< SubStateMachine[" + subStateMachine.getStateMachineName() + "] execute finish with status[" + (Object)((Object)subStateMachineInstance.getStatus()) + "], compensateStatus[" + (Object)((Object)subStateMachineInstance.getCompensationStatus()) + "]");
            }
        }
        catch (Exception e) {
            LOGGER.error("SubStateMachine[" + subStateMachine.getStateMachineName() + "] execute failed by state[name:" + subStateMachine.getName() + "]", (Throwable)e);
            if (e instanceof ForwardInvalidException) {
                String retriedId = stateInstance.getStateIdRetriedFor();
                StateInstance stateToBeRetried = null;
                for (StateInstance stateInst : stateMachineInstance.getStateList()) {
                    if (!retriedId.equals(stateInst.getId())) continue;
                    stateToBeRetried = stateInst;
                    break;
                }
                if (stateToBeRetried != null) {
                    stateInstance.setStatus(stateToBeRetried.getStatus());
                }
            }
            context.setVariable("currentException", e);
            ServiceTaskStateHandler.handleException(context, subStateMachine, e);
        }
    }

    private StateMachineInstance callSubStateMachine(Map<String, Object> startParams, StateMachineEngine engine, ProcessContext context, StateInstance stateInstance, SubStateMachine subStateMachine) {
        if (!context.hasVariable("_is_for_sub_statemachine_forward_")) {
            return this.startNewStateMachine(startParams, engine, stateInstance, subStateMachine);
        }
        context.removeVariable("_is_for_sub_statemachine_forward_");
        return this.forwardStateMachine(startParams, engine, context, stateInstance, subStateMachine);
    }

    private static ExecutionStatus decideStatus(StateMachineInstance stateMachineInstance, boolean isForward) {
        if (isForward && ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus())) {
            return ExecutionStatus.SU;
        }
        if (stateMachineInstance.getCompensationStatus() == null || ExecutionStatus.FA.equals((Object)stateMachineInstance.getCompensationStatus())) {
            return stateMachineInstance.getStatus();
        }
        if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getCompensationStatus())) {
            return ExecutionStatus.FA;
        }
        return ExecutionStatus.UN;
    }

    private StateMachineInstance startNewStateMachine(Map<String, Object> startParams, StateMachineEngine engine, StateInstance stateInstance, SubStateMachine subStateMachine) {
        StateMachineInstance subStateMachineInstance = stateInstance.getBusinessKey() != null ? engine.startWithBusinessKey(subStateMachine.getStateMachineName(), stateInstance.getStateMachineInstance().getTenantId(), stateInstance.getBusinessKey(), startParams) : engine.start(subStateMachine.getStateMachineName(), stateInstance.getStateMachineInstance().getTenantId(), startParams);
        return subStateMachineInstance;
    }

    private StateMachineInstance forwardStateMachine(Map<String, Object> startParams, StateMachineEngine engine, ProcessContext context, StateInstance stateInstance, SubStateMachine subStateMachine) {
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        StateLogStore statePersister = stateMachineConfig.getStateLogStore();
        if (statePersister == null) {
            throw new ForwardInvalidException("StatePersister is not configured", FrameworkErrorCode.ObjectNotExists);
        }
        StateInstance originalStateInst = stateInstance;
        while (StringUtils.hasText((String)(originalStateInst = statePersister.getStateInstance(originalStateInst.getStateIdRetriedFor(), originalStateInst.getMachineInstanceId())).getStateIdRetriedFor())) {
        }
        List<StateMachineInstance> subInst = statePersister.queryStateMachineInstanceByParentId(EngineUtils.generateParentId(originalStateInst));
        if (subInst.size() > 0) {
            String subInstId = subInst.get(0).getId();
            return engine.forward(subInstId, startParams);
        }
        throw new ForwardInvalidException("Cannot find sub statemachine [" + subStateMachine.getStateMachineName() + "]", FrameworkErrorCode.ObjectNotExists);
    }

    @Override
    public List<StateHandlerInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<StateHandlerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

