/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.util;

import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.DefaultRemotingParser;
import io.seata.spring.util.SpringProxyUtils;
import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;

public class TCCBeanParserUtils {
    public static boolean isTccAutoProxy(Object bean, String beanName, ApplicationContext applicationContext) {
        RemotingDesc remotingDesc = null;
        boolean isRemotingBean = TCCBeanParserUtils.parserRemotingServiceInfo(bean, beanName);
        if (isRemotingBean) {
            remotingDesc = DefaultRemotingParser.get().getRemotingBeanDesc(beanName);
            if (remotingDesc != null && remotingDesc.getProtocol() == 5) {
                return TCCBeanParserUtils.isTccProxyTargetBean(remotingDesc);
            }
            return false;
        }
        remotingDesc = DefaultRemotingParser.get().getRemotingBeanDesc(beanName);
        if (remotingDesc == null) {
            if (TCCBeanParserUtils.isRemotingFactoryBean(bean, beanName, applicationContext)) {
                remotingDesc = DefaultRemotingParser.get().getRemotingBeanDesc(beanName);
                return TCCBeanParserUtils.isTccProxyTargetBean(remotingDesc);
            }
            return false;
        }
        return TCCBeanParserUtils.isTccProxyTargetBean(remotingDesc);
    }

    protected static boolean isRemotingFactoryBean(Object bean, String beanName, ApplicationContext applicationContext) {
        if (!SpringProxyUtils.isProxy(bean)) {
            return false;
        }
        String factoryBeanName = "&" + beanName;
        Object factoryBean = null;
        if (applicationContext != null && applicationContext.containsBean(factoryBeanName)) {
            factoryBean = applicationContext.getBean(factoryBeanName);
        }
        if (factoryBean == null) {
            return false;
        }
        return TCCBeanParserUtils.parserRemotingServiceInfo(factoryBean, beanName);
    }

    protected static boolean isTccProxyTargetBean(RemotingDesc remotingDesc) {
        if (remotingDesc == null) {
            return false;
        }
        boolean isTccClazz = false;
        Class<?> tccInterfaceClazz = remotingDesc.getInterfaceClass();
        Method[] methods = tccInterfaceClazz.getMethods();
        TwoPhaseBusinessAction twoPhaseBusinessAction = null;
        for (Method method : methods) {
            twoPhaseBusinessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
            if (twoPhaseBusinessAction == null) continue;
            isTccClazz = true;
            break;
        }
        if (!isTccClazz) {
            return false;
        }
        short protocols = remotingDesc.getProtocol();
        if (5 == protocols) {
            return true;
        }
        return remotingDesc.isReference();
    }

    protected static boolean parserRemotingServiceInfo(Object bean, String beanName) {
        if (DefaultRemotingParser.get().isRemoting(bean, beanName)) {
            return null != DefaultRemotingParser.get().parserRemotingServiceInfo(bean, beanName);
        }
        return false;
    }

    public static RemotingDesc getRemotingDesc(String beanName) {
        return DefaultRemotingParser.get().getRemotingBeanDesc(beanName);
    }
}

