/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.AbstractConnectionProxy;
import io.seata.rm.datasource.ConnectionContext;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.exec.LockConflictException;
import io.seata.rm.datasource.exec.LockRetryController;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.rm.datasource.undo.UndoLogManagerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProxy
extends AbstractConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxy.class);
    private ConnectionContext context = new ConnectionContext();
    private static final int REPORT_RETRY_COUNT = ConfigurationFactory.getInstance().getInt("client.rm.reportRetryCount", 5);
    public static final boolean IS_REPORT_SUCCESS_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.rm.reportSuccessEnable", false);
    private static final LockRetryPolicy LOCK_RETRY_POLICY = new LockRetryPolicy();

    public ConnectionProxy(DataSourceProxy dataSourceProxy, Connection targetConnection) {
        super(dataSourceProxy, targetConnection);
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public void bind(String xid) {
        this.context.bind(xid);
    }

    public void setGlobalLockRequire(boolean isLock) {
        this.context.setGlobalLockRequire(isLock);
    }

    public boolean isGlobalLockRequire() {
        return this.context.isGlobalLockRequire();
    }

    public void checkLock(String lockKeys) throws SQLException {
        if (StringUtils.isBlank(lockKeys)) {
            return;
        }
        try {
            boolean lockable = DefaultResourceManager.get().lockQuery(BranchType.AT, this.getDataSourceProxy().getResourceId(), this.context.getXid(), lockKeys);
            if (!lockable) {
                throw new LockConflictException();
            }
        }
        catch (TransactionException e) {
            this.recognizeLockKeyConflictException(e, lockKeys);
        }
    }

    public boolean lockQuery(String lockKeys) throws SQLException {
        boolean result = false;
        try {
            result = DefaultResourceManager.get().lockQuery(BranchType.AT, this.getDataSourceProxy().getResourceId(), this.context.getXid(), lockKeys);
        }
        catch (TransactionException e) {
            this.recognizeLockKeyConflictException(e, lockKeys);
        }
        return result;
    }

    private void recognizeLockKeyConflictException(TransactionException te) throws SQLException {
        this.recognizeLockKeyConflictException(te, null);
    }

    private void recognizeLockKeyConflictException(TransactionException te, String lockKeys) throws SQLException {
        if (te.getCode() == TransactionExceptionCode.LockKeyConflict) {
            StringBuilder reasonBuilder = new StringBuilder("get global lock fail, xid:");
            reasonBuilder.append(this.context.getXid());
            if (StringUtils.isNotBlank(lockKeys)) {
                reasonBuilder.append(", lockKeys:").append(lockKeys);
            }
            throw new LockConflictException(reasonBuilder.toString());
        }
        throw new SQLException(te);
    }

    public void appendUndoLog(SQLUndoLog sqlUndoLog) {
        this.context.appendUndoItem(sqlUndoLog);
    }

    public void appendLockKey(String lockKey) {
        this.context.appendLockKey(lockKey);
    }

    @Override
    public void commit() throws SQLException {
        try {
            LOCK_RETRY_POLICY.execute(() -> {
                this.doCommit();
                return null;
            });
        }
        catch (SQLException e) {
            if (this.targetConnection != null && !this.getAutoCommit()) {
                this.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private void doCommit() throws SQLException {
        if (this.context.inGlobalTransaction()) {
            this.processGlobalTransactionCommit();
        } else if (this.context.isGlobalLockRequire()) {
            this.processLocalCommitWithGlobalLocks();
        } else {
            this.targetConnection.commit();
        }
    }

    private void processLocalCommitWithGlobalLocks() throws SQLException {
        this.checkLock(this.context.buildLockKeys());
        try {
            this.targetConnection.commit();
        }
        catch (Throwable ex) {
            throw new SQLException(ex);
        }
        this.context.reset();
    }

    private void processGlobalTransactionCommit() throws SQLException {
        try {
            this.register();
        }
        catch (TransactionException e) {
            this.recognizeLockKeyConflictException(e, this.context.buildLockKeys());
        }
        try {
            UndoLogManagerFactory.getUndoLogManager(this.getDbType()).flushUndoLogs(this);
            this.targetConnection.commit();
        }
        catch (Throwable ex) {
            LOGGER.error("process connectionProxy commit error: {}", (Object)ex.getMessage(), (Object)ex);
            this.report(false);
            throw new SQLException(ex);
        }
        if (IS_REPORT_SUCCESS_ENABLE) {
            this.report(true);
        }
        this.context.reset();
    }

    private void register() throws TransactionException {
        if (!this.context.hasUndoLog() || this.context.getLockKeysBuffer().isEmpty()) {
            return;
        }
        Long branchId = DefaultResourceManager.get().branchRegister(BranchType.AT, this.getDataSourceProxy().getResourceId(), null, this.context.getXid(), null, this.context.buildLockKeys());
        this.context.setBranchId(branchId);
    }

    @Override
    public void rollback() throws SQLException {
        this.targetConnection.rollback();
        if (this.context.inGlobalTransaction() && this.context.isBranchRegistered()) {
            this.report(false);
        }
        this.context.reset();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if ((this.context.inGlobalTransaction() || this.context.isGlobalLockRequire()) && autoCommit && !this.getAutoCommit()) {
            this.doCommit();
        }
        this.targetConnection.setAutoCommit(autoCommit);
    }

    private void report(boolean commitDone) throws SQLException {
        if (this.context.getBranchId() == null) {
            return;
        }
        int retry = REPORT_RETRY_COUNT;
        while (retry > 0) {
            try {
                DefaultResourceManager.get().branchReport(BranchType.AT, this.context.getXid(), this.context.getBranchId(), commitDone ? BranchStatus.PhaseOne_Done : BranchStatus.PhaseOne_Failed, null);
                return;
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to report [" + this.context.getBranchId() + "/" + this.context.getXid() + "] commit done [" + commitDone + "] Retry Countdown: " + retry);
                if (--retry != 0) continue;
                throw new SQLException("Failed to report branch status " + commitDone, ex);
            }
        }
    }

    public static class LockRetryPolicy {
        protected static final boolean LOCK_RETRY_POLICY_BRANCH_ROLLBACK_ON_CONFLICT = ConfigurationFactory.getInstance().getBoolean("client.rm.lock.retryPolicyBranchRollbackOnConflict", true);

        public <T> T execute(Callable<T> callable) throws Exception {
            if (LOCK_RETRY_POLICY_BRANCH_ROLLBACK_ON_CONFLICT) {
                return callable.call();
            }
            return this.doRetryOnLockConflict(callable);
        }

        protected <T> T doRetryOnLockConflict(Callable<T> callable) throws Exception {
            LockRetryController lockRetryController = new LockRetryController();
            while (true) {
                try {
                    return callable.call();
                }
                catch (LockConflictException lockConflict) {
                    this.onException(lockConflict);
                    lockRetryController.sleep(lockConflict);
                    continue;
                }
                catch (Exception e) {
                    this.onException(e);
                    throw e;
                }
                break;
            }
        }

        protected void onException(Exception e) throws Exception {
        }
    }
}

