/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.hsf;

import com.taobao.hsf.context.RPCContext;
import com.taobao.hsf.invocation.Invocation;
import com.taobao.hsf.invocation.InvocationHandler;
import com.taobao.hsf.invocation.RPCResult;
import com.taobao.hsf.invocation.filter.ClientFilter;
import com.taobao.hsf.invocation.filter.ServerFilter;
import com.taobao.hsf.util.concurrent.ListenableFuture;
import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsfTransactionFilter
implements ClientFilter,
ServerFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HsfTransactionFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RPCResult> invoke(InvocationHandler invocationHandler, Invocation invocation) throws Throwable {
        ListenableFuture listenableFuture;
        block19: {
            String xid = RootContext.getXID();
            BranchType branchType = RootContext.getBranchType();
            Object rpcXid = RPCContext.getServerContext().getAttachment("TX_XID");
            Object rpcBranchType = RPCContext.getServerContext().getAttachment("TX_BRANCH_TYPE");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xid in RootContext[{}] xid in RpcContext[{}]", (Object)xid, rpcXid);
            }
            boolean bind = false;
            if (xid != null) {
                RPCContext.getClientContext().putAttachment("TX_XID", (Object)xid);
                RPCContext.getClientContext().putAttachment("TX_BRANCH_TYPE", (Object)branchType.name());
            } else if (rpcXid != null) {
                RootContext.bind(rpcXid.toString());
                if (StringUtils.equals(BranchType.TCC.name(), rpcBranchType.toString())) {
                    RootContext.bindBranchType(BranchType.TCC);
                }
                bind = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("bind xid [{}] branchType [{}] to RootContext", rpcXid, rpcBranchType);
                }
            }
            try {
                listenableFuture = invocationHandler.invoke(invocation);
                if (!bind) break block19;
            }
            catch (Throwable throwable) {
                if (bind) {
                    BranchType previousBranchType = RootContext.getBranchType();
                    String unbindXid = RootContext.unbind();
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.unbindBranchType();
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
                    }
                    if (!rpcXid.toString().equalsIgnoreCase(unbindXid)) {
                        LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType});
                        if (unbindXid != null) {
                            RootContext.bind(unbindXid);
                            LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                            if (BranchType.TCC == previousBranchType) {
                                RootContext.bindBranchType(BranchType.TCC);
                                LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                            }
                        }
                    }
                }
                RPCContext.getClientContext().removeAttachment("TX_XID");
                RPCContext.getClientContext().removeAttachment("TX_BRANCH_TYPE");
                RPCContext.getServerContext().removeAttachment("TX_XID");
                RPCContext.getServerContext().removeAttachment("TX_BRANCH_TYPE");
                throw throwable;
            }
            BranchType previousBranchType = RootContext.getBranchType();
            String unbindXid = RootContext.unbind();
            if (BranchType.TCC == previousBranchType) {
                RootContext.unbindBranchType();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
            }
            if (!rpcXid.toString().equalsIgnoreCase(unbindXid)) {
                LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType});
                if (unbindXid != null) {
                    RootContext.bind(unbindXid);
                    LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.bindBranchType(BranchType.TCC);
                        LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                    }
                }
            }
        }
        RPCContext.getClientContext().removeAttachment("TX_XID");
        RPCContext.getClientContext().removeAttachment("TX_BRANCH_TYPE");
        RPCContext.getServerContext().removeAttachment("TX_XID");
        RPCContext.getServerContext().removeAttachment("TX_BRANCH_TYPE");
        return listenableFuture;
    }

    public void onResponse(Invocation invocation, RPCResult rpcResult) {
    }
}

