/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.serializer.impl;

import io.seata.saga.engine.serializer.Serializer;
import io.seata.saga.statelang.parser.JsonParser;
import io.seata.saga.statelang.parser.JsonParserFactory;

public class ParamsSerializer
implements Serializer<Object, String> {
    private String jsonParserName = "fastjson";

    @Override
    public String serialize(Object params) {
        if (params != null) {
            JsonParser jsonParser = JsonParserFactory.getJsonParser(this.jsonParserName);
            if (jsonParser == null) {
                throw new RuntimeException("Cannot find JsonParer by name: " + this.jsonParserName);
            }
            return jsonParser.toJsonString(params, false);
        }
        return null;
    }

    @Override
    public Object deserialize(String json) {
        if (json != null) {
            JsonParser jsonParser = JsonParserFactory.getJsonParser(this.jsonParserName);
            if (jsonParser == null) {
                throw new RuntimeException("Cannot find JsonParer by name: " + this.jsonParserName);
            }
            return jsonParser.parse(json, Object.class, false);
        }
        return null;
    }

    public String getJsonParserName() {
        return this.jsonParserName;
    }

    public void setJsonParserName(String jsonParserName) {
        this.jsonParserName = jsonParserName;
    }
}

