/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.AbstractDMLBaseExecutor;
import io.seata.rm.datasource.exec.MultiDeleteExecutor;
import io.seata.rm.datasource.exec.MultiUpdateExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.sqlserver.SqlServerMultiDeleteExecutor;
import io.seata.rm.datasource.exec.sqlserver.SqlServerMultiUpdateExecutor;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLType;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MultiExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    private Map<String, List<SQLRecognizer>> multiSqlGroup = new HashMap<String, List<SQLRecognizer>>(4);
    private Map<SQLRecognizer, TableRecords> beforeImagesMap = new HashMap<SQLRecognizer, TableRecords>(4);
    private Map<SQLRecognizer, TableRecords> afterImagesMap = new HashMap<SQLRecognizer, TableRecords>(4);

    public MultiExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        this.multiSqlGroup = this.sqlRecognizers.stream().collect(Collectors.groupingBy(t -> t.getTableName()));
        AbstractDMLBaseExecutor executor = null;
        for (List<SQLRecognizer> value : this.multiSqlGroup.values()) {
            switch (value.get(0).getSQLType()) {
                case UPDATE: {
                    if ("sqlserver".equalsIgnoreCase(this.getDbType())) {
                        executor = new SqlServerMultiUpdateExecutor(this.statementProxy, this.statementCallback, value);
                        break;
                    }
                    executor = new MultiUpdateExecutor(this.statementProxy, this.statementCallback, value);
                    break;
                }
                case DELETE: {
                    if ("sqlserver".equalsIgnoreCase(this.getDbType())) {
                        executor = new SqlServerMultiDeleteExecutor(this.statementProxy, this.statementCallback, value);
                        break;
                    }
                    executor = new MultiDeleteExecutor(this.statementProxy, this.statementCallback, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not support sql" + value.get(0).getOriginalSQL());
                }
            }
            TableRecords beforeImage = executor.beforeImage();
            this.beforeImagesMap.put(value.get(0), beforeImage);
        }
        return null;
    }

    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        AbstractDMLBaseExecutor executor = null;
        for (List<SQLRecognizer> value : this.multiSqlGroup.values()) {
            switch (value.get(0).getSQLType()) {
                case UPDATE: {
                    if ("sqlserver".equalsIgnoreCase(this.getDbType())) {
                        executor = new SqlServerMultiUpdateExecutor(this.statementProxy, this.statementCallback, value);
                        break;
                    }
                    executor = new MultiUpdateExecutor(this.statementProxy, this.statementCallback, value);
                    break;
                }
                case DELETE: {
                    if ("sqlserver".equalsIgnoreCase(this.getDbType())) {
                        executor = new SqlServerMultiDeleteExecutor(this.statementProxy, this.statementCallback, value);
                        break;
                    }
                    executor = new MultiDeleteExecutor(this.statementProxy, this.statementCallback, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not support sql" + value.get(0).getOriginalSQL());
                }
            }
            beforeImage = this.beforeImagesMap.get(value.get(0));
            TableRecords afterImage = executor.afterImage(beforeImage);
            this.afterImagesMap.put(value.get(0), afterImage);
        }
        return null;
    }

    @Override
    protected void prepareUndoLog(TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (this.beforeImagesMap == null || this.afterImagesMap == null) {
            throw new IllegalStateException("images can not be null");
        }
        for (Map.Entry<SQLRecognizer, TableRecords> entry : this.beforeImagesMap.entrySet()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = entry.getKey();
            beforeImage = entry.getValue();
            afterImage = this.afterImagesMap.get(recognizer);
            if (SQLType.UPDATE == this.sqlRecognizer.getSQLType() && beforeImage.getRows().size() != afterImage.getRows().size()) {
                throw new ShouldNeverHappenException("Before image size is not equaled to after image size, probably because you updated the primary keys.");
            }
            super.prepareUndoLog(beforeImage, afterImage);
        }
    }

    public Map<String, List<SQLRecognizer>> getMultiSqlGroup() {
        return this.multiSqlGroup;
    }

    public Map<SQLRecognizer, TableRecords> getBeforeImagesMap() {
        return this.beforeImagesMap;
    }

    public Map<SQLRecognizer, TableRecords> getAfterImagesMap() {
        return this.afterImagesMap;
    }
}

