/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.impl;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.util.CollectionUtils;
import io.seata.saga.engine.AsyncCallback;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.StateMachineEngine;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.exception.ForwardInvalidException;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.pcext.utils.LoopTaskUtils;
import io.seata.saga.engine.pcext.utils.ParameterUtils;
import io.seata.saga.engine.utils.ProcessContextBuilder;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.ProcessType;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.domain.impl.CompensationTriggerStateImpl;
import io.seata.saga.statelang.domain.impl.LoopStartStateImpl;
import io.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import io.seata.saga.statelang.domain.impl.StateMachineInstanceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ProcessCtrlStateMachineEngine
implements StateMachineEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCtrlStateMachineEngine.class);
    private StateMachineConfig stateMachineConfig;

    private static void nullSafeCopy(Map<String, Object> srcMap, Map<String, Object> destMap) {
        srcMap.forEach((key, value) -> {
            if (value != null) {
                destMap.put((String)key, value);
            }
        });
    }

    @Override
    public StateMachineInstance start(String stateMachineName, String tenantId, Map<String, Object> startParams) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, null, startParams, false, null);
    }

    @Override
    public StateMachineInstance startAsync(String stateMachineName, String tenantId, Map<String, Object> startParams, AsyncCallback callback) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, null, startParams, true, callback);
    }

    @Override
    public StateMachineInstance startWithBusinessKey(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, businessKey, startParams, false, null);
    }

    @Override
    public StateMachineInstance startWithBusinessKeyAsync(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams, AsyncCallback callback) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, businessKey, startParams, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateMachineInstance startInternal(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams, boolean async, AsyncCallback callback) throws EngineExecutionException {
        try {
            StateInstruction stateInstruction;
            TaskState.Loop loop;
            ConcurrentHashMap<String, Object> contextVariables;
            if (async && !this.stateMachineConfig.isEnableAsync()) {
                throw new EngineExecutionException("Asynchronous start is disabled. please set StateMachineConfig.enableAsync=true first.", FrameworkErrorCode.AsynchronousStartDisabled);
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                tenantId = this.stateMachineConfig.getDefaultTenantId();
            }
            StateMachineInstance instance = this.createMachineInstance(stateMachineName, tenantId, businessKey, startParams);
            ProcessContextBuilder contextBuilder = ProcessContextBuilder.create().withProcessType(ProcessType.STATE_LANG).withOperationName("start").withAsyncCallback(callback).withInstruction(new StateInstruction(stateMachineName, tenantId)).withStateMachineInstance(instance).withStateMachineConfig(this.getStateMachineConfig()).withStateMachineEngine(this);
            if (startParams != null) {
                contextVariables = new ConcurrentHashMap(startParams.size());
                ProcessCtrlStateMachineEngine.nullSafeCopy(startParams, contextVariables);
            } else {
                contextVariables = new ConcurrentHashMap<String, Object>();
            }
            instance.setContext(contextVariables);
            contextBuilder.withStateMachineContextVariables(contextVariables);
            contextBuilder.withIsAsyncExecution(async);
            ProcessContext processContext = contextBuilder.build();
            if (instance.getStateMachine().isPersist() && this.stateMachineConfig.getStateLogStore() != null) {
                this.stateMachineConfig.getStateLogStore().recordStateMachineStarted(instance, processContext);
            }
            if (StringUtils.isEmpty((Object)instance.getId())) {
                instance.setId(this.stateMachineConfig.getSeqGenerator().generate("STATE_MACHINE_INST"));
            }
            if (null != (loop = LoopTaskUtils.getLoopConfig(processContext, (stateInstruction = processContext.getInstruction(StateInstruction.class)).getState(processContext)))) {
                stateInstruction.setTemporaryState(new LoopStartStateImpl());
            }
            if (async) {
                this.stateMachineConfig.getAsyncProcessCtrlEventPublisher().publish(processContext);
            } else {
                this.stateMachineConfig.getProcessCtrlEventPublisher().publish(processContext);
            }
            StateMachineInstance stateMachineInstance = instance;
            return stateMachineInstance;
        }
        finally {
            if (this.stateMachineConfig.getStateLogStore() != null) {
                this.stateMachineConfig.getStateLogStore().clearUp();
            }
        }
    }

    private StateMachineInstance createMachineInstance(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams) {
        StateMachine stateMachine = this.stateMachineConfig.getStateMachineRepository().getStateMachine(stateMachineName, tenantId);
        if (stateMachine == null) {
            throw new EngineExecutionException("StateMachine[" + stateMachineName + "] is not exists", FrameworkErrorCode.ObjectNotExists);
        }
        StateMachineInstanceImpl inst = new StateMachineInstanceImpl();
        inst.setStateMachine(stateMachine);
        inst.setMachineId(stateMachine.getId());
        inst.setTenantId(tenantId);
        inst.setBusinessKey(businessKey);
        inst.setStartParams(startParams);
        if (startParams != null) {
            String parentId;
            if (StringUtils.hasText((String)businessKey)) {
                startParams.put("_business_key_", businessKey);
            }
            if (StringUtils.hasText((String)(parentId = (String)startParams.get("_parent_id_")))) {
                inst.setParentId(parentId);
                startParams.remove("_parent_id_");
            }
        }
        inst.setStatus(ExecutionStatus.RU);
        inst.setRunning(true);
        inst.setGmtStarted(new Date());
        inst.setGmtUpdated(inst.getGmtStarted());
        return inst;
    }

    @Override
    public StateMachineInstance forward(String stateMachineInstId, Map<String, Object> replaceParams) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, replaceParams, false, false, null);
    }

    @Override
    public StateMachineInstance forwardAsync(String stateMachineInstId, Map<String, Object> replaceParams, AsyncCallback callback) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, replaceParams, false, true, callback);
    }

    protected StateMachineInstance forwardInternal(String stateMachineInstId, Map<String, Object> replaceParams, boolean skip, boolean async, AsyncCallback callback) throws EngineExecutionException {
        StateMachineInstance stateMachineInstance = this.reloadStateMachineInstance(stateMachineInstId);
        if (stateMachineInstance == null) {
            throw new ForwardInvalidException("StateMachineInstance is not exits", FrameworkErrorCode.StateMachineInstanceNotExists);
        }
        if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus()) && stateMachineInstance.getCompensationStatus() == null) {
            return stateMachineInstance;
        }
        ExecutionStatus[] acceptStatus = new ExecutionStatus[]{ExecutionStatus.FA, ExecutionStatus.UN, ExecutionStatus.RU};
        this.checkStatus(stateMachineInstance, acceptStatus, null, stateMachineInstance.getStatus(), null, "forward");
        List<StateInstance> actList = stateMachineInstance.getStateList();
        if (CollectionUtils.isEmpty(actList)) {
            throw new ForwardInvalidException("StateMachineInstance[id:" + stateMachineInstId + "] has no stateInstance, pls start a new StateMachine execution instead", FrameworkErrorCode.OperationDenied);
        }
        StateInstance lastForwardState = this.findOutLastForwardStateInstance(actList);
        if (lastForwardState == null) {
            throw new ForwardInvalidException("StateMachineInstance[id:" + stateMachineInstId + "] Cannot find last forward execution stateInstance", FrameworkErrorCode.OperationDenied);
        }
        ProcessContextBuilder contextBuilder = ProcessContextBuilder.create().withProcessType(ProcessType.STATE_LANG).withOperationName("forward").withAsyncCallback(callback).withStateMachineInstance(stateMachineInstance).withStateInstance(lastForwardState).withStateMachineConfig(this.getStateMachineConfig()).withStateMachineEngine(this);
        contextBuilder.withIsAsyncExecution(async);
        ProcessContext context = contextBuilder.build();
        Map<String, Object> contextVariables = this.getStateMachineContextVariables(stateMachineInstance);
        if (replaceParams != null) {
            contextVariables.putAll(replaceParams);
        }
        this.putBusinesskeyToContextariables(stateMachineInstance, contextVariables);
        ConcurrentHashMap<String, Object> concurrentContextVariables = new ConcurrentHashMap<String, Object>(contextVariables.size());
        ProcessCtrlStateMachineEngine.nullSafeCopy(contextVariables, concurrentContextVariables);
        context.setVariable("context", concurrentContextVariables);
        stateMachineInstance.setContext(concurrentContextVariables);
        String originStateName = EngineUtils.getOriginStateName(lastForwardState);
        State lastState = stateMachineInstance.getStateMachine().getState(originStateName);
        TaskState.Loop loop = LoopTaskUtils.getLoopConfig(context, lastState);
        if (null != loop && ExecutionStatus.SU.equals((Object)lastForwardState.getStatus())) {
            lastForwardState = LoopTaskUtils.findOutLastNeedForwardStateInstance(context);
        }
        context.setVariable(lastForwardState.getName() + "_retried_state_instance_id", lastForwardState.getId());
        if ("SubStateMachine".equals(lastForwardState.getType()) && !ExecutionStatus.SU.equals((Object)lastForwardState.getCompensationStatus())) {
            context.setVariable("_is_for_sub_statemachine_forward_", true);
        }
        if (!ExecutionStatus.SU.equals((Object)lastForwardState.getStatus())) {
            lastForwardState.setIgnoreStatus(true);
        }
        try {
            StateInstruction inst = new StateInstruction();
            inst.setTenantId(stateMachineInstance.getTenantId());
            inst.setStateMachineName(stateMachineInstance.getStateMachine().getName());
            if (skip || ExecutionStatus.SU.equals((Object)lastForwardState.getStatus())) {
                String next = null;
                State state = stateMachineInstance.getStateMachine().getState(EngineUtils.getOriginStateName(lastForwardState));
                if (state instanceof AbstractTaskState) {
                    next = state.getNext();
                }
                if (StringUtils.isEmpty(next)) {
                    LOGGER.warn("Last Forward execution StateInstance was succeed, and it has not Next State , skip forward operation");
                    return stateMachineInstance;
                }
                inst.setStateName(next);
            } else {
                if (ExecutionStatus.RU.equals((Object)lastForwardState.getStatus()) && !EngineUtils.isTimeout(lastForwardState.getGmtStarted(), this.stateMachineConfig.getServiceInvokeTimeout())) {
                    throw new EngineExecutionException("State [" + lastForwardState.getName() + "] is running, operation[forward] denied", FrameworkErrorCode.OperationDenied);
                }
                inst.setStateName(EngineUtils.getOriginStateName(lastForwardState));
            }
            context.setInstruction(inst);
            stateMachineInstance.setStatus(ExecutionStatus.RU);
            stateMachineInstance.setRunning(true);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Operation [forward] started  stateMachineInstance[id:" + stateMachineInstance.getId() + "]");
            }
            if (stateMachineInstance.getStateMachine().isPersist()) {
                this.stateMachineConfig.getStateLogStore().recordStateMachineRestarted(stateMachineInstance, context);
            }
            if (null != (loop = LoopTaskUtils.getLoopConfig(context, inst.getState(context)))) {
                inst.setTemporaryState(new LoopStartStateImpl());
            }
            if (async) {
                this.stateMachineConfig.getAsyncProcessCtrlEventPublisher().publish(context);
            } else {
                this.stateMachineConfig.getProcessCtrlEventPublisher().publish(context);
            }
        }
        catch (EngineExecutionException e) {
            LOGGER.error("Operation [forward] failed", (Throwable)e);
            throw e;
        }
        return stateMachineInstance;
    }

    private Map<String, Object> getStateMachineContextVariables(StateMachineInstance stateMachineInstance) {
        Map<String, Object> contextVariables = stateMachineInstance.getEndParams();
        if (CollectionUtils.isEmpty(contextVariables)) {
            contextVariables = this.replayContextVariables(stateMachineInstance);
        }
        return contextVariables;
    }

    protected Map<String, Object> replayContextVariables(StateMachineInstance stateMachineInstance) {
        List<StateInstance> stateInstanceList;
        HashMap<String, Object> contextVariables = new HashMap<String, Object>();
        if (stateMachineInstance.getStartParams() == null) {
            contextVariables.putAll(stateMachineInstance.getStartParams());
        }
        if (CollectionUtils.isEmpty(stateInstanceList = stateMachineInstance.getStateList())) {
            return contextVariables;
        }
        for (StateInstance stateInstance : stateInstanceList) {
            Object serviceOutputParams = stateInstance.getOutputParams();
            if (serviceOutputParams == null) continue;
            ServiceTaskStateImpl state = (ServiceTaskStateImpl)stateMachineInstance.getStateMachine().getState(EngineUtils.getOriginStateName(stateInstance));
            if (state == null) {
                throw new EngineExecutionException("Cannot find State by state name [" + stateInstance.getName() + "], may be this is a bug", FrameworkErrorCode.ObjectNotExists);
            }
            if (!CollectionUtils.isNotEmpty(state.getOutput())) continue;
            try {
                Map<String, Object> outputVariablesToContext = ParameterUtils.createOutputParams(this.stateMachineConfig.getExpressionResolver(), state, serviceOutputParams);
                if (CollectionUtils.isNotEmpty(outputVariablesToContext)) {
                    contextVariables.putAll(outputVariablesToContext);
                }
                if (!StringUtils.hasLength((String)stateInstance.getBusinessKey())) continue;
                contextVariables.put(state.getName() + "_business_key_", stateInstance.getBusinessKey());
            }
            catch (Exception e) {
                throw new EngineExecutionException(e, "Context variables replay faied", FrameworkErrorCode.ContextVariableReplayFailed);
            }
        }
        return contextVariables;
    }

    public StateInstance findOutLastForwardStateInstance(List<StateInstance> stateInstanceList) {
        StateInstance lastForwardStateInstance = null;
        for (int i = stateInstanceList.size() - 1; i >= 0; --i) {
            StateInstance stateInstance = stateInstanceList.get(i);
            if (stateInstance.isForCompensation() || ExecutionStatus.SU.equals((Object)stateInstance.getCompensationStatus())) continue;
            if ("SubStateMachine".equals(stateInstance.getType())) {
                StateInstance finalState = stateInstance;
                while (StringUtils.hasText((String)finalState.getStateIdRetriedFor())) {
                    finalState = this.stateMachineConfig.getStateLogStore().getStateInstance(finalState.getStateIdRetriedFor(), finalState.getMachineInstanceId());
                }
                List<StateMachineInstance> subInst = this.stateMachineConfig.getStateLogStore().queryStateMachineInstanceByParentId(EngineUtils.generateParentId(finalState));
                if (CollectionUtils.isNotEmpty(subInst)) {
                    if (ExecutionStatus.SU.equals((Object)subInst.get(0).getCompensationStatus())) continue;
                    if (ExecutionStatus.UN.equals((Object)subInst.get(0).getCompensationStatus())) {
                        throw new ForwardInvalidException("Last forward execution state instance is SubStateMachine and compensation status is [UN], Operation[forward] denied, stateInstanceId:" + stateInstance.getId(), FrameworkErrorCode.OperationDenied);
                    }
                }
            } else if (ExecutionStatus.UN.equals((Object)stateInstance.getCompensationStatus())) {
                throw new ForwardInvalidException("Last forward execution state instance compensation status is [UN], Operation[forward] denied, stateInstanceId:" + stateInstance.getId(), FrameworkErrorCode.OperationDenied);
            }
            lastForwardStateInstance = stateInstance;
            break;
        }
        return lastForwardStateInstance;
    }

    @Override
    public StateMachineInstance compensate(String stateMachineInstId, Map<String, Object> replaceParams) throws EngineExecutionException {
        return this.compensateInternal(stateMachineInstId, replaceParams, false, null);
    }

    @Override
    public StateMachineInstance compensateAsync(String stateMachineInstId, Map<String, Object> replaceParams, AsyncCallback callback) throws EngineExecutionException {
        return this.compensateInternal(stateMachineInstId, replaceParams, true, callback);
    }

    public StateMachineInstance compensateInternal(String stateMachineInstId, Map<String, Object> replaceParams, boolean async, AsyncCallback callback) throws EngineExecutionException {
        StateMachineInstance stateMachineInstance = this.reloadStateMachineInstance(stateMachineInstId);
        if (stateMachineInstance == null) {
            throw new EngineExecutionException("StateMachineInstance is not exits", FrameworkErrorCode.StateMachineInstanceNotExists);
        }
        if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getCompensationStatus())) {
            return stateMachineInstance;
        }
        if (stateMachineInstance.getCompensationStatus() != null) {
            ExecutionStatus[] denyStatus = new ExecutionStatus[]{ExecutionStatus.SU};
            this.checkStatus(stateMachineInstance, null, denyStatus, null, stateMachineInstance.getCompensationStatus(), "compensate");
        }
        if (replaceParams != null) {
            stateMachineInstance.getEndParams().putAll(replaceParams);
        }
        ProcessContextBuilder contextBuilder = ProcessContextBuilder.create().withProcessType(ProcessType.STATE_LANG).withOperationName("compensate").withAsyncCallback(callback).withStateMachineInstance(stateMachineInstance).withStateMachineConfig(this.getStateMachineConfig()).withStateMachineEngine(this);
        contextBuilder.withIsAsyncExecution(async);
        ProcessContext context = contextBuilder.build();
        Map<String, Object> contextVariables = this.getStateMachineContextVariables(stateMachineInstance);
        if (replaceParams != null) {
            contextVariables.putAll(replaceParams);
        }
        this.putBusinesskeyToContextariables(stateMachineInstance, contextVariables);
        ConcurrentHashMap<String, Object> concurrentContextVariables = new ConcurrentHashMap<String, Object>(contextVariables.size());
        ProcessCtrlStateMachineEngine.nullSafeCopy(contextVariables, concurrentContextVariables);
        context.setVariable("context", concurrentContextVariables);
        stateMachineInstance.setContext(concurrentContextVariables);
        CompensationTriggerStateImpl tempCompensationTriggerState = new CompensationTriggerStateImpl();
        tempCompensationTriggerState.setStateMachine(stateMachineInstance.getStateMachine());
        stateMachineInstance.setRunning(true);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Operation [compensate] start.  stateMachineInstance[id:" + stateMachineInstance.getId() + "]");
        }
        if (stateMachineInstance.getStateMachine().isPersist()) {
            this.stateMachineConfig.getStateLogStore().recordStateMachineRestarted(stateMachineInstance, context);
        }
        try {
            StateInstruction inst = new StateInstruction();
            inst.setTenantId(stateMachineInstance.getTenantId());
            inst.setStateMachineName(stateMachineInstance.getStateMachine().getName());
            inst.setTemporaryState(tempCompensationTriggerState);
            context.setInstruction(inst);
            if (async) {
                this.stateMachineConfig.getAsyncProcessCtrlEventPublisher().publish(context);
            } else {
                this.stateMachineConfig.getProcessCtrlEventPublisher().publish(context);
            }
        }
        catch (EngineExecutionException e) {
            LOGGER.error("Operation [compensate] failed", (Throwable)e);
            throw e;
        }
        return stateMachineInstance;
    }

    @Override
    public StateMachineInstance skipAndForward(String stateMachineInstId, Map<String, Object> replaceParams) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, replaceParams, false, true, null);
    }

    @Override
    public StateMachineInstance skipAndForwardAsync(String stateMachineInstId, AsyncCallback callback) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, null, false, true, callback);
    }

    @Override
    public StateMachineInstance reloadStateMachineInstance(String instId) {
        StateMachineInstance inst = this.stateMachineConfig.getStateLogStore().getStateMachineInstance(instId);
        if (inst != null) {
            StateMachine stateMachine = inst.getStateMachine();
            if (stateMachine == null) {
                stateMachine = this.stateMachineConfig.getStateMachineRepository().getStateMachineById(inst.getMachineId());
                inst.setStateMachine(stateMachine);
            }
            if (stateMachine == null) {
                throw new EngineExecutionException("StateMachine[id:" + inst.getMachineId() + "] not exist.", FrameworkErrorCode.ObjectNotExists);
            }
            List<StateInstance> stateList = inst.getStateList();
            if (CollectionUtils.isEmpty(stateList) && CollectionUtils.isNotEmpty(stateList = this.stateMachineConfig.getStateLogStore().queryStateInstanceListByMachineInstanceId(instId))) {
                for (StateInstance tmpStateInstance : stateList) {
                    inst.putStateInstance(tmpStateInstance.getId(), tmpStateInstance);
                }
            }
            if (CollectionUtils.isEmpty(inst.getEndParams())) {
                inst.setEndParams(this.replayContextVariables(inst));
            }
        }
        return inst;
    }

    protected boolean checkStatus(StateMachineInstance stateMachineInstance, ExecutionStatus[] acceptStatus, ExecutionStatus[] denyStatus, ExecutionStatus status, ExecutionStatus compenStatus, String operation) {
        ExecutionStatus currentStatus;
        if (status != null && compenStatus != null) {
            throw new EngineExecutionException("status and compensationStatus are not supported at the same time", FrameworkErrorCode.InvalidParameter);
        }
        if (status == null && compenStatus == null) {
            throw new EngineExecutionException("status and compensationStatus must input at least one", FrameworkErrorCode.InvalidParameter);
        }
        if (ExecutionStatus.SU.equals((Object)compenStatus)) {
            String message = this.buildExceptionMessage(stateMachineInstance, null, null, null, ExecutionStatus.SU, operation);
            throw new EngineExecutionException(message, FrameworkErrorCode.OperationDenied);
        }
        if (stateMachineInstance.isRunning() && !EngineUtils.isTimeout(stateMachineInstance.getGmtUpdated(), this.stateMachineConfig.getTransOperationTimeout())) {
            throw new EngineExecutionException("StateMachineInstance [id:" + stateMachineInstance.getId() + "] is running, operation[" + operation + "] denied", FrameworkErrorCode.OperationDenied);
        }
        if (!(denyStatus != null && denyStatus.length != 0 || acceptStatus != null && acceptStatus.length != 0)) {
            throw new EngineExecutionException("StateMachineInstance[id:" + stateMachineInstance.getId() + "], acceptable status and deny status must input at least one", FrameworkErrorCode.InvalidParameter);
        }
        ExecutionStatus executionStatus = currentStatus = status != null ? status : compenStatus;
        if (denyStatus != null && denyStatus.length != 0) {
            for (ExecutionStatus tempDenyStatus : denyStatus) {
                if (tempDenyStatus.compareTo(currentStatus) != 0) continue;
                String message = this.buildExceptionMessage(stateMachineInstance, acceptStatus, denyStatus, status, compenStatus, operation);
                throw new EngineExecutionException(message, FrameworkErrorCode.OperationDenied);
            }
        }
        if (acceptStatus == null || acceptStatus.length == 0) {
            return true;
        }
        for (ExecutionStatus tempStatus : acceptStatus) {
            if (tempStatus.compareTo(currentStatus) != 0) continue;
            return true;
        }
        String message = this.buildExceptionMessage(stateMachineInstance, acceptStatus, denyStatus, status, compenStatus, operation);
        throw new EngineExecutionException(message, FrameworkErrorCode.OperationDenied);
    }

    private String buildExceptionMessage(StateMachineInstance stateMachineInstance, ExecutionStatus[] acceptStatus, ExecutionStatus[] denyStatus, ExecutionStatus status, ExecutionStatus compenStatus, String operation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StateMachineInstance[id:").append(stateMachineInstance.getId()).append("]");
        if (acceptStatus != null) {
            stringBuilder.append(",acceptable status :");
            for (ExecutionStatus tempStatus : acceptStatus) {
                stringBuilder.append(tempStatus.toString());
                stringBuilder.append(" ");
            }
        }
        if (denyStatus != null) {
            stringBuilder.append(",deny status:");
            for (ExecutionStatus tempStatus : denyStatus) {
                stringBuilder.append(tempStatus.toString());
                stringBuilder.append(" ");
            }
        }
        if (status != null) {
            stringBuilder.append(",current status:");
            stringBuilder.append(status.toString());
        }
        if (compenStatus != null) {
            stringBuilder.append(",current compensation status:");
            stringBuilder.append(compenStatus.toString());
        }
        stringBuilder.append(",so operation [").append(operation).append("] denied");
        return stringBuilder.toString();
    }

    private void putBusinesskeyToContextariables(StateMachineInstance stateMachineInstance, Map<String, Object> contextVariables) {
        if (StringUtils.hasText((String)stateMachineInstance.getBusinessKey()) && !contextVariables.containsKey("_business_key_")) {
            contextVariables.put("_business_key_", stateMachineInstance.getBusinessKey());
        }
    }

    @Override
    public StateMachineConfig getStateMachineConfig() {
        return this.stateMachineConfig;
    }

    public void setStateMachineConfig(StateMachineConfig stateMachineConfig) {
        this.stateMachineConfig = stateMachineConfig;
    }
}

