/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.formatter.eclipse.ExtendedCodeFormatter;
import io.spring.javaformat.formatter.preparator.Preparators;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.TextEdit;

public class Formatter
extends CodeFormatter {
    private static final int DEFAULT_COMPONENTS = 4104;
    private static final int DEFAULT_INDENTATION_LEVEL = 0;
    public static final String DEFAULT_LINE_SEPARATOR = null;
    private final CodeFormatter delegate;

    public Formatter() {
        this(JavaFormatConfig.DEFAULT);
    }

    public Formatter(JavaFormatConfig javaFormatConfig) {
        this.delegate = new DelegateCodeFormatter(javaFormatConfig);
    }

    public TextEdit format(String source) {
        return this.format(source, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, String lineSeparator) {
        return this.format(source, 0, source.length(), lineSeparator);
    }

    public TextEdit format(String source, int offset, int length) {
        return this.format(source, offset, length, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, int offset, int length, String lineSeparator) {
        return this.format(4104, source, offset, length, 0, lineSeparator);
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        return this.delegate.format(kind, source, offset, length, indentationLevel, lineSeparator);
    }

    public TextEdit format(String source, IRegion[] regions) {
        return this.format(source, regions, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, IRegion[] regions, String lineSeparator) {
        return this.format(4104, source, regions, 0, lineSeparator);
    }

    public TextEdit format(int kind, String source, IRegion[] regions, int indentationLevel, String lineSeparator) {
        return this.delegate.format(kind, source, regions, indentationLevel, lineSeparator);
    }

    public String createIndentationString(int indentationLevel) {
        return this.delegate.createIndentationString(indentationLevel);
    }

    public void setOptions(Map<String, String> options) {
        this.delegate.setOptions(options);
    }

    private static class DelegateCodeFormatter
    extends ExtendedCodeFormatter {
        private final Map<String, String> appliedOptions;

        DelegateCodeFormatter(JavaFormatConfig javaFormatConfig) {
            this(DelegateCodeFormatter.loadOptions(javaFormatConfig));
        }

        DelegateCodeFormatter(Map<String, String> options) {
            super(options);
            this.appliedOptions = options;
            Preparators.forEach(arg_0 -> ((DelegateCodeFormatter)this).addPreparator(arg_0));
        }

        public void setOptions(Map<String, String> options) {
            super.setOptions(this.appliedOptions);
        }

        private static Map<String, String> loadOptions(JavaFormatConfig javaFormatConfig) {
            try {
                Properties properties = new Properties();
                try (InputStream inputStream = Formatter.class.getResourceAsStream("formatter.prefs");){
                    properties.load(inputStream);
                }
                DelegateCodeFormatter.applyConfig(properties, javaFormatConfig);
                return Collections.unmodifiableMap(properties);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private static void applyConfig(Properties properties, JavaFormatConfig javaFormatConfig) {
            if (javaFormatConfig.getIndentationStyle() == IndentationStyle.SPACES) {
                properties.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
            }
        }
    }
}

