/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.preparator;

import io.spring.javaformat.formatter.eclipse.Preparator;
import io.spring.javaformat.formatter.eclipse.Token;
import io.spring.javaformat.formatter.eclipse.TokenManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

class JavadocLineBreakPreparator
implements Preparator {
    private static final List<String> PARAM_TAGS;

    JavadocLineBreakPreparator() {
    }

    public void apply(int kind, TokenManager tokenManager, ASTNode astRoot) {
        if ((kind & 0x1000) != 0) {
            Vistor visitor = new Vistor(tokenManager);
            for (Comment comment : this.getComments(astRoot)) {
                comment.accept((ASTVisitor)visitor);
            }
        }
    }

    private List<Comment> getComments(ASTNode astRoot) {
        if (astRoot.getRoot() instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)astRoot.getRoot();
            return compilationUnit.getCommentList();
        }
        return Collections.emptyList();
    }

    static {
        ArrayList<String> paramTags = new ArrayList<String>();
        paramTags.add("@param");
        paramTags.add("@exception");
        paramTags.add("@serialField");
        paramTags.add("@throws");
        paramTags.add("@return");
        paramTags.add("@deprecated");
        PARAM_TAGS = Collections.unmodifiableList(paramTags);
    }

    private static class Vistor
    extends ASTVisitor {
        private final TokenManager tokenManager;
        private TokenManager commentTokenManager;
        private ASTNode declaration;
        private boolean firstTagElement;
        private boolean hasText;

        Vistor(TokenManager tokenManager) {
            this.tokenManager = tokenManager;
        }

        public boolean visit(Javadoc node) {
            int commentIndex = this.tokenManager.firstIndexIn((ASTNode)node, 1003);
            Token commentToken = this.tokenManager.get(commentIndex);
            this.commentTokenManager = new TokenManager(commentToken.getInternalStructure(), this.tokenManager);
            this.declaration = node.getParent();
            this.firstTagElement = true;
            this.hasText = false;
            return true;
        }

        public boolean visit(TextElement node) {
            this.hasText = true;
            return true;
        }

        public boolean visit(TagElement node) {
            if (this.isSquashRequired(node, this.declaration)) {
                int startIndex = this.commentTokenManager.findIndex(node.getStartPosition(), -1, false);
                Token token = this.commentTokenManager.get(startIndex);
                token.clearLineBreaksBefore();
                token.putLineBreaksBefore(this.declaration instanceof TypeDeclaration && this.firstTagElement && this.hasText ? 2 : 1);
                this.firstTagElement = false;
            }
            return true;
        }

        private boolean isSquashRequired(TagElement node, ASTNode declaration) {
            if (declaration instanceof TypeDeclaration) {
                String tagName = node.getTagName();
                return !node.isNested() && tagName != null && tagName.startsWith("@");
            }
            return PARAM_TAGS.contains(node.getTagName());
        }
    }
}

