/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.collect;

import brave.internal.Nullable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WeakConcurrentMap<K, V>
extends ReferenceQueue<K> {
    final ConcurrentMap<WeakKey<K>, V> target = new ConcurrentHashMap<WeakKey<K>, V>();

    @Nullable
    public V getIfPresent(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.expungeStaleEntries();
        return this.target.get(key);
    }

    @Nullable
    public V putIfProbablyAbsent(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        this.expungeStaleEntries();
        return this.target.putIfAbsent(new WeakKey<K>(key, this), value);
    }

    @Nullable
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.expungeStaleEntries();
        return this.target.remove(key);
    }

    protected void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.removeStaleEntry(reference);
        }
    }

    protected V removeStaleEntry(Reference<?> reference) {
        return this.target.remove(reference);
    }

    public String toString() {
        Class<?> thisClass = this.getClass();
        while (thisClass.getSimpleName().isEmpty()) {
            thisClass = thisClass.getSuperclass();
        }
        this.expungeStaleEntries();
        return thisClass.getSimpleName() + this.target.keySet();
    }

    static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == null ? b == null : a.equals(b);
    }

    static final class WeakKey<T>
    extends WeakReference<T> {
        final int hashCode;

        WeakKey(T key, ReferenceQueue<? super T> queue) {
            super(key, queue);
            this.hashCode = key.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object value = this.get();
            return value != null ? value.toString() : "ClearedReference()";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            assert (o instanceof WeakReference) : "Bug: unexpected input to equals";
            return WeakConcurrentMap.equal(this.get(), ((WeakReference)o).get());
        }
    }
}

