/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.Iterator;
import java.util.List;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;

public final class StrictTraceId {
    public static Call.Mapper<List<Span>, List<Span>> filterSpans(String traceId) {
        return new FilterSpans(traceId);
    }

    public static Call.Mapper<List<List<Span>>, List<List<Span>>> filterTraces(QueryRequest request) {
        return new FilterTraces(request);
    }

    static final class FilterSpans
    implements Call.Mapper<List<Span>, List<Span>> {
        final String traceId;

        FilterSpans(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public List<Span> map(List<Span> input) {
            Iterator<Span> i = input.iterator();
            while (i.hasNext()) {
                Span next = i.next();
                if (next.traceId().equals(this.traceId)) continue;
                i.remove();
            }
            return input;
        }

        public String toString() {
            return "FilterSpans{traceId=" + this.traceId + "}";
        }
    }

    static final class FilterTraces
    implements Call.Mapper<List<List<Span>>, List<List<Span>>> {
        final QueryRequest request;

        FilterTraces(QueryRequest request) {
            this.request = request;
        }

        @Override
        public List<List<Span>> map(List<List<Span>> input) {
            Iterator<List<Span>> i = input.iterator();
            while (i.hasNext()) {
                List<Span> next = i.next();
                if (next.get(0).traceId().length() <= 16 || this.request.test(next)) continue;
                i.remove();
            }
            return input;
        }

        public String toString() {
            return "FilterTraces{request=" + this.request + "}";
        }
    }
}

