/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.design.base.DRDesignHyperLink;
import net.sf.dynamicreports.design.base.DRDesignParameter;
import net.sf.dynamicreports.design.base.DRDesignQuery;
import net.sf.dynamicreports.design.base.DRDesignTemplateDesign;
import net.sf.dynamicreports.design.definition.DRIDesignParameter;
import net.sf.dynamicreports.design.definition.DRIDesignTemplateDesign;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.DRIParameter;
import net.sf.dynamicreports.report.definition.DRIQuery;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.exception.DRException;

public class ReportTransform {
    private DesignTransformAccessor accessor;
    private DRIDesignTemplateDesign templateDesign;
    private DRDesignQuery query;
    private List<DRIDesignParameter> parameters;
    private DRIDesignExpression filterExpression;

    public ReportTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.parameters = new ArrayList<DRIDesignParameter>();
    }

    public void transform() throws DRException {
        DRIReport report = this.accessor.getReport();
        this.templateDesign = new DRDesignTemplateDesign(report.getTemplateDesign());
        if (report.getQuery() != null) {
            this.query = this.query(report.getQuery());
        }
        for (DRIParameter<?> parameter : report.getParameters()) {
            this.parameters.add(this.parameter(parameter));
        }
        this.filterExpression = this.accessor.getExpressionTransform().transformExpression(report.getFilterExpression(), "DYNAMICREPORTS_SCRIPTLET");
    }

    protected DRDesignQuery query(DRIQuery query) {
        DRDesignQuery designQuery = new DRDesignQuery();
        designQuery.setText(query.getText());
        designQuery.setLanguage(query.getLanguage());
        return designQuery;
    }

    private DRDesignParameter parameter(DRIParameter<?> parameter) {
        DRDesignParameter designParameter = new DRDesignParameter();
        designParameter.setName(parameter.getName());
        designParameter.setValueClass(parameter.getValueClass());
        designParameter.setValue(parameter.getValue());
        designParameter.setExternal(this.accessor.getReport().getTemplateDesign().isDefinedParameter(parameter.getName()));
        return designParameter;
    }

    public DRDesignHyperLink hyperlink(DRIHyperLink hyperLink) throws DRException {
        if (hyperLink == null) {
            return null;
        }
        DRDesignHyperLink designHyperLink = new DRDesignHyperLink();
        designHyperLink.setAnchorExpression(this.accessor.getExpressionTransform().transformExpression(hyperLink.getAnchorExpression()));
        designHyperLink.setPageExpression(this.accessor.getExpressionTransform().transformExpression(hyperLink.getPageExpression()));
        designHyperLink.setReferenceExpression(this.accessor.getExpressionTransform().transformExpression(hyperLink.getReferenceExpression()));
        designHyperLink.setTooltipExpression(this.accessor.getExpressionTransform().transformExpression(hyperLink.getTooltipExpression()));
        designHyperLink.setType(hyperLink.getType());
        designHyperLink.setTarget(hyperLink.getTarget());
        return designHyperLink;
    }

    public DRIDesignTemplateDesign getTemplateDesign() {
        return this.templateDesign;
    }

    public DRDesignQuery getQuery() {
        return this.query;
    }

    public List<DRIDesignParameter> getParameters() {
        return this.parameters;
    }

    public DRIDesignExpression getFilterExpression() {
        return this.filterExpression;
    }
}

