/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignBand;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.constant.EvaluationTime;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.ColumnGrid;
import net.sf.dynamicreports.design.transformation.ConstantTransform;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.TemplateTransform;
import net.sf.dynamicreports.report.base.component.DRFiller;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.Position;
import net.sf.dynamicreports.report.constant.SubtotalPosition;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;
import net.sf.dynamicreports.report.definition.DRIBand;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.DRISubtotal;
import net.sf.dynamicreports.report.definition.column.DRIColumn;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class SubtotalTransform {
    private DesignTransformAccessor accessor;

    public SubtotalTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
    }

    public void transform() throws DRException {
        DRDesignBand band;
        DRDesignGroup designGroup;
        DRIBand bnd;
        DRIGroup group;
        ColumnGrid title = this.accessor.getColumnGridTransform().createColumnGrid();
        ColumnGrid pageHeader = this.accessor.getColumnGridTransform().createColumnGrid();
        ColumnGrid pageFooter = this.accessor.getColumnGridTransform().createColumnGrid();
        ColumnGrid columnHeader = this.accessor.getColumnGridTransform().createColumnGrid();
        ColumnGrid columnFooter = this.accessor.getColumnGridTransform().createColumnGrid();
        HashMap<DRIGroup, ColumnGrid> groupHeader = new HashMap<DRIGroup, ColumnGrid>();
        HashMap<DRIGroup, ColumnGrid> groupFooter = new HashMap<DRIGroup, ColumnGrid>();
        ColumnGrid lastPageFooter = this.accessor.getColumnGridTransform().createColumnGrid();
        ColumnGrid summary = this.accessor.getColumnGridTransform().createColumnGrid();
        HorizontalCellComponentAlignment horizontalAlignment = HorizontalCellComponentAlignment.FLOAT;
        VerticalCellComponentAlignment verticalAlignment = VerticalCellComponentAlignment.TOP;
        block15: for (DRISubtotal<?> subtotal : this.accessor.getReport().getSubtotals()) {
            DRDesignTextField subtotalValueComponent;
            SubtotalPosition position = subtotal.getPosition();
            DRIColumn<?> showInColumn = subtotal.getShowInColumn();
            DRDesignComponent subtotalComponent = subtotalValueComponent = this.valueComponent(subtotal);
            if (subtotal.getLabelExpression() != null) {
                subtotalComponent = this.subtotalWithLabelComponent(subtotal, subtotalComponent);
            }
            switch (position) {
                case TITLE: {
                    title.addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case PAGE_HEADER: {
                    pageHeader.addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case PAGE_FOOTER: {
                    pageFooter.addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case COLUMN_HEADER: {
                    columnHeader.addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case COLUMN_FOOTER: {
                    columnFooter.addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case GROUP_HEADER: {
                    EvaluationTime evaluationTime = this.accessor.getComponentTransform().detectEvaluationTime(subtotalValueComponent.getValueExpression());
                    if (evaluationTime == null || !evaluationTime.equals((Object)EvaluationTime.AUTO)) {
                        subtotalValueComponent.setEvaluationTime(EvaluationTime.GROUP);
                        subtotalValueComponent.setEvaluationGroup(this.accessor.getGroupTransform().getGroup(subtotal.getGroup()));
                    }
                    this.getGroupGrid(subtotal.getGroup(), groupHeader).addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case GROUP_FOOTER: {
                    EvaluationTime evaluationTime = this.accessor.getComponentTransform().detectEvaluationTime(subtotalValueComponent.getValueExpression());
                    if (evaluationTime == null || !evaluationTime.equals((Object)EvaluationTime.AUTO)) {
                        subtotalValueComponent.setEvaluationTime(EvaluationTime.NOW);
                    }
                    this.getGroupGrid(subtotal.getGroup(), groupFooter).addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case FIRST_GROUP_HEADER: {
                    DRIGroup firstGroup = this.accessor.getGroupTransform().getFirstGroup();
                    EvaluationTime evaluationTime = this.accessor.getComponentTransform().detectEvaluationTime(subtotalValueComponent.getValueExpression());
                    if (evaluationTime == null || !evaluationTime.equals((Object)EvaluationTime.AUTO)) {
                        subtotalValueComponent.setEvaluationTime(EvaluationTime.GROUP);
                        subtotalValueComponent.setEvaluationGroup(this.accessor.getGroupTransform().getGroup(firstGroup));
                    }
                    if (firstGroup == null) continue block15;
                    this.getGroupGrid(firstGroup, groupHeader).addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case FIRST_GROUP_FOOTER: {
                    DRIGroup firstGroup = this.accessor.getGroupTransform().getFirstGroup();
                    if (firstGroup == null) continue block15;
                    EvaluationTime evaluationTime = this.accessor.getComponentTransform().detectEvaluationTime(subtotalValueComponent.getValueExpression());
                    if (evaluationTime == null || !evaluationTime.equals((Object)EvaluationTime.AUTO)) {
                        subtotalValueComponent.setEvaluationTime(EvaluationTime.NOW);
                    }
                    this.getGroupGrid(firstGroup, groupFooter).addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case LAST_GROUP_HEADER: {
                    DRIGroup lastGroup = this.accessor.getGroupTransform().getLastGroup();
                    EvaluationTime evaluationTime = this.accessor.getComponentTransform().detectEvaluationTime(subtotalValueComponent.getValueExpression());
                    if (evaluationTime == null || !evaluationTime.equals((Object)EvaluationTime.AUTO)) {
                        subtotalValueComponent.setEvaluationTime(EvaluationTime.GROUP);
                        subtotalValueComponent.setEvaluationGroup(this.accessor.getGroupTransform().getGroup(lastGroup));
                    }
                    if (lastGroup == null) continue block15;
                    this.getGroupGrid(lastGroup, groupHeader).addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case LAST_GROUP_FOOTER: {
                    DRIGroup lastGroup = this.accessor.getGroupTransform().getLastGroup();
                    if (lastGroup == null) continue block15;
                    EvaluationTime evaluationTime = this.accessor.getComponentTransform().detectEvaluationTime(subtotalValueComponent.getValueExpression());
                    if (evaluationTime == null || !evaluationTime.equals((Object)EvaluationTime.AUTO)) {
                        subtotalValueComponent.setEvaluationTime(EvaluationTime.NOW);
                    }
                    this.getGroupGrid(lastGroup, groupFooter).addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case LAST_PAGE_FOOTER: {
                    lastPageFooter.addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
                case SUMMARY: {
                    subtotalValueComponent.setEvaluationTime(EvaluationTime.NOW);
                    summary.addComponent(showInColumn, horizontalAlignment, verticalAlignment, subtotalComponent);
                    continue block15;
                }
            }
            throw new DRDesignReportException("Subtotal position " + position.name() + " not supported");
        }
        DRFiller filler = null;
        TemplateTransform templateTransform = this.accessor.getTemplateTransform();
        if (templateTransform.getPageColumnsPerPage() > 1) {
            int fillerWidth = this.accessor.getPageTransform().getMaxBandWidth() - this.accessor.getPageTransform().getPage().getColumnWidth();
            filler = new DRFiller();
            filler.setWidth(fillerWidth);
        }
        this.addAfterBandComponent(this.accessor.getBandTransform().getTitleBand(), title, filler);
        this.addAfterBandComponent(this.accessor.getBandTransform().getPageHeaderBand(), pageHeader, filler);
        this.addBeforeBandComponent(this.accessor.getBandTransform().getPageFooterBand(), pageFooter, filler);
        this.addAfterBandComponent(this.accessor.getBandTransform().getColumnHeaderBand(), columnHeader, null);
        this.addBeforeBandComponent(this.accessor.getBandTransform().getColumnFooterBand(), columnFooter, null);
        for (Map.Entry entry : groupHeader.entrySet()) {
            group = (DRIGroup)entry.getKey();
            bnd = group.getHeaderBand();
            designGroup = this.accessor.getGroupTransform().getGroup(group);
            band = this.accessor.getBandTransform().band("subtotalGroupHeader", bnd, templateTransform.getGroupHeaderSplitType(bnd), templateTransform.getGroupHeaderStyle(bnd), templateTransform.getGroupHeaderBackgroundComponent(bnd));
            this.addAfterBandComponent(band, (ColumnGrid)entry.getValue(), null);
            this.setPrintGroupSubtotalsWhenExpression(group, (ColumnGrid)entry.getValue());
            designGroup.addHeaderBand(band);
        }
        for (Map.Entry entry : groupFooter.entrySet()) {
            group = (DRIGroup)entry.getKey();
            bnd = group.getFooterBand();
            designGroup = this.accessor.getGroupTransform().getGroup(group);
            band = this.accessor.getBandTransform().band("subtotalGroupFooter", bnd, templateTransform.getGroupFooterSplitType(bnd), templateTransform.getGroupFooterStyle(bnd), templateTransform.getGroupFooterBackgroundComponent(bnd));
            this.addBeforeBandComponent(band, (ColumnGrid)entry.getValue(), null);
            this.setPrintGroupSubtotalsWhenExpression(group, (ColumnGrid)entry.getValue());
            designGroup.addFooterBand(0, band);
        }
        this.addBeforeBandComponent(this.accessor.getBandTransform().getLastPageFooterBand(), lastPageFooter, filler);
        this.addBeforeBandComponent(this.accessor.getBandTransform().getSummaryBand(), summary, filler);
    }

    private DRDesignComponent subtotalWithLabelComponent(DRISubtotal<?> subtotal, DRDesignComponent subtotalComponent) throws DRException {
        HorizontalCellComponentAlignment horizontalAlignment = HorizontalCellComponentAlignment.FLOAT;
        VerticalCellComponentAlignment verticalAlignment = VerticalCellComponentAlignment.TOP;
        DRDesignList list = new DRDesignList();
        Position labelPosition = this.accessor.getTemplateTransform().getSubtotalLabelPosition(subtotal);
        switch (labelPosition) {
            case TOP: {
                list.setType(ListType.VERTICAL);
                list.addComponent(horizontalAlignment, verticalAlignment, this.labelComponent(subtotal));
                list.addComponent(horizontalAlignment, verticalAlignment, subtotalComponent);
                break;
            }
            case BOTTOM: {
                list.setType(ListType.VERTICAL);
                list.addComponent(horizontalAlignment, verticalAlignment, subtotalComponent);
                list.addComponent(horizontalAlignment, verticalAlignment, this.labelComponent(subtotal));
                break;
            }
            case LEFT: {
                list.setType(ListType.HORIZONTAL);
                DRDesignComponent labelComponent = this.labelComponent(subtotal);
                if (subtotal.getLabelWidth() != null) {
                    labelComponent.setWidth(subtotal.getLabelWidth());
                }
                HorizontalCellComponentAlignment labelHorizontalAlignment = horizontalAlignment;
                if (subtotal.getLabelWidthType() != null) {
                    labelHorizontalAlignment = ConstantTransform.toHorizontalCellComponentAlignment(subtotal.getLabelWidthType());
                }
                list.addComponent(labelHorizontalAlignment, VerticalCellComponentAlignment.EXPAND, labelComponent);
                list.addComponent(horizontalAlignment, VerticalCellComponentAlignment.EXPAND, subtotalComponent);
                break;
            }
            case RIGHT: {
                list.setType(ListType.HORIZONTAL);
                DRDesignComponent labelComponent = this.labelComponent(subtotal);
                if (subtotal.getLabelWidth() != null) {
                    labelComponent.setWidth(subtotal.getLabelWidth());
                }
                HorizontalCellComponentAlignment labelHorizontalAlignment = horizontalAlignment;
                if (subtotal.getLabelWidthType() != null) {
                    labelHorizontalAlignment = ConstantTransform.toHorizontalCellComponentAlignment(subtotal.getLabelWidthType());
                }
                list.addComponent(horizontalAlignment, VerticalCellComponentAlignment.EXPAND, subtotalComponent);
                list.addComponent(labelHorizontalAlignment, VerticalCellComponentAlignment.EXPAND, labelComponent);
                break;
            }
            default: {
                throw new DRDesignReportException("Subtotal label position " + labelPosition.name() + " not supported");
            }
        }
        return list;
    }

    private ColumnGrid getGroupGrid(DRIGroup group, Map<DRIGroup, ColumnGrid> groupList) throws DRException {
        if (!groupList.containsKey(group)) {
            groupList.put(group, this.accessor.getColumnGridTransform().createColumnGrid());
        }
        return groupList.get(group);
    }

    private void setPrintGroupSubtotalsWhenExpression(DRIGroup group, ColumnGrid grid) throws DRException {
        DRIExpression<Boolean> printSubtotalsWhenExpression = group.getPrintSubtotalsWhenExpression();
        if (grid.isEmpty() || printSubtotalsWhenExpression == null) {
            return;
        }
        grid.getList().setPrintWhenExpression(this.accessor.getExpressionTransform().transformExpression(printSubtotalsWhenExpression));
    }

    private void addAfterBandComponent(DRDesignBand band, ColumnGrid grid, DRFiller filler) throws DRException {
        if (grid.isEmpty()) {
            return;
        }
        DRDesignList list = grid.getList();
        if (filler != null) {
            list = new DRDesignList();
            list.addComponent(grid.getList());
            list.addComponent(HorizontalCellComponentAlignment.LEFT, null, this.accessor.getComponentTransform().filler(filler));
        }
        band.addComponent(list);
    }

    private void addBeforeBandComponent(DRDesignBand band, ColumnGrid grid, DRFiller filler) throws DRException {
        if (grid.isEmpty()) {
            return;
        }
        DRDesignList list = grid.getList();
        if (filler != null) {
            list = new DRDesignList();
            list.addComponent(grid.getList());
            list.addComponent(HorizontalCellComponentAlignment.LEFT, null, this.accessor.getComponentTransform().filler(filler));
        }
        band.addComponent(0, list);
    }

    private DRDesignComponent labelComponent(DRISubtotal<?> subtotal) throws DRException {
        DRTextField labelField = new DRTextField();
        labelField.setValueExpression(subtotal.getLabelExpression());
        labelField.setStyle(subtotal.getLabelStyle());
        labelField.setWidth(this.accessor.getTemplateTransform().getColumnWidth(subtotal.getShowInColumn(), this.accessor.getStyleTransform().getDefaultStyle(DefaultStyleType.COLUMN)));
        DRDesignTextField designLabelField = this.accessor.getComponentTransform().textField(labelField, DefaultStyleType.TEXT);
        designLabelField.setUniqueName("column_" + subtotal.getShowInColumn().getName() + ".subtotal.label");
        return designLabelField;
    }

    private DRDesignTextField valueComponent(DRISubtotal<?> subtotal) throws DRException {
        DRDesignTextField designValueField = this.accessor.getComponentTransform().textField(subtotal.getValueField(), DefaultStyleType.SUBTOTAL);
        designValueField.setUniqueName("column_" + subtotal.getShowInColumn().getName() + ".subtotal");
        designValueField.setWidth(this.accessor.getTemplateTransform().getColumnWidth(subtotal.getShowInColumn(), this.accessor.getStyleTransform().getDefaultStyle(DefaultStyleType.COLUMN)));
        return designValueField;
    }
}

