/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.io.Serializable;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import net.sf.dynamicreports.report.definition.chart.plot.DRIPaintScale;
import net.sf.dynamicreports.report.definition.chart.plot.DRIXyBlockPlot;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class XyBlockRendererCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    private DRIXyBlockPlot xyBlockPlot;

    public XyBlockRendererCustomizer(DRIXyBlockPlot xyBlockPlot) {
        this.xyBlockPlot = xyBlockPlot;
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        chart.getXYPlot().getDomainAxis().setUpperMargin(0.0);
        chart.getXYPlot().getRangeAxis().setUpperMargin(0.0);
        XYBlockRenderer renderer = new XYBlockRenderer();
        if (this.xyBlockPlot.getBlockWidth() != null) {
            renderer.setBlockWidth(this.xyBlockPlot.getBlockWidth().doubleValue());
        }
        if (this.xyBlockPlot.getBlockHeight() != null) {
            renderer.setBlockHeight(this.xyBlockPlot.getBlockHeight().doubleValue());
        }
        if (this.xyBlockPlot.getBlockAnchor() != null) {
            renderer.setBlockAnchor(ConstantTransform.rectangleAnchor(this.xyBlockPlot.getBlockAnchor()));
        }
        LookupPaintScale paintScale = new LookupPaintScale(this.xyBlockPlot.getDefaultLowerBound(), this.xyBlockPlot.getDefaultUpperBound(), this.xyBlockPlot.getDefaultPaint());
        for (DRIPaintScale scale : this.xyBlockPlot.getPaintScales()) {
            paintScale.add(scale.getValue(), scale.getPaint());
        }
        renderer.setPaintScale((PaintScale)paintScale);
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        LegendItemCollection legendItems = new LegendItemCollection();
        for (DRIPaintScale scale : this.xyBlockPlot.getPaintScales()) {
            legendItems.add(new LegendItem(scale.getLabel(), scale.getPaint()));
        }
        chart.getXYPlot().setFixedLegendItems(legendItems);
    }
}

