/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.util.List;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstab;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabMeasure;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabVariable;
import net.sf.dynamicreports.report.definition.expression.DRIComplexExpression;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class CrosstabExpression<T>
extends AbstractComplexExpression<T> {
    private static final long serialVersionUID = 10000L;
    private DRIExpression<T> expression;

    public CrosstabExpression(DRICrosstab crosstab, DRIExpression<T> expression) throws DRException {
        this.expression = expression;
        if (expression instanceof DRIComplexExpression) {
            for (DRIExpression<?> dRIExpression : ((DRIComplexExpression)expression).getExpressions()) {
                this.addExpression(dRIExpression);
            }
        }
        for (DRICrosstabVariable dRICrosstabVariable : crosstab.getVariables()) {
            this.addExpression(dRICrosstabVariable);
        }
        for (DRICrosstabMeasure dRICrosstabMeasure : crosstab.getMeasures()) {
            if (!(dRICrosstabMeasure.getExpression() instanceof DRICrosstabVariable)) continue;
            this.addExpression(dRICrosstabMeasure.getExpression());
        }
    }

    @Override
    public T evaluate(List<?> values, ReportParameters reportParameters) {
        DRICustomValues customValues = (DRICustomValues)reportParameters.getParameterValue("CUSTOM_VALUES");
        for (int i = 0; i < this.getExpressions().size(); ++i) {
            customValues.setSystemValue(this.getExpressions().get(i).getName(), values.get(i));
        }
        if (this.expression instanceof DRIComplexExpression) {
            DRIComplexExpression express = (DRIComplexExpression)this.expression;
            return express.evaluate(values, reportParameters);
        }
        return reportParameters.getValue(this.expression.getName());
    }

    @Override
    public Class getValueClass() {
        return this.expression.getValueClass();
    }
}

